/* vokoscreen - A desktop recorder
 * Copyright (C) 2011-2014 Volker Kohaupt
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301 USA
 */

#ifndef VOKOSCREEN_H
#define VOKOSCREEN_H

#include <QMainWindow>
#include <QPushButton>
#include <QComboBox>
#include <QSpinBox>
#include <QRadioButton>
#include <QScrollArea>
#include <QSystemTrayIcon>
#include <QMessageBox>
#include <QSettings>
#include <QLineEdit>
#include <QFileDialog>
#include <QDate>
#include <QStatusBar>
#include <QDesktopWidget>
#include <QDial>
#include <QAction>
#include <QTest>
#include <QDateTime>
#include <QListWidget>
#include <QFileSystemWatcher>

#include "QvkSettings.h"
#include "QvkRegionController.h"

#include "QvkMagnifier.h"
#include "QvkWebcamController.h"
#include "QvkAlsaDevice.h"
#include "QvkMail.h"
#include "QvkAlsaWatcher.h"
#include "QvkWinInfo.h"
#include "QvkCredits.h"
#include "QvkVersion.h"
#include "ui_QvkNoPlayerDialog.h"
#include <QxtGlobalShortcut>
#include "QvkShowkeyController.h"

#include "QvkAnimateControl.h"
#include "QvkShowClickDialog.h"

#include "QvkFormatsAndCodecs.h"


#include "ui_vokoscreen.h"

class screencast : public QMainWindow
{ 
Q_OBJECT
public:
  screencast();
  virtual ~screencast();
  QProcess *SystemCall;
  QString deltaX;
  QString deltaY;
  QString deltaXMove;
  QString deltaYMove;
  QString nameInMoviesLocation;
  QString moviePath;
  QString ffmpegProgram;
  QStringList ffmpegInputArguments;
  QStringList ffmpegOutputArguments;
  bool firststartWininfo;
  //QString vokoscreenLoaded;
  
public:
#ifndef NO_NEW_VERSION_CHECK
    QvkVersion version;
#endif
    
    
public slots:
    // Only for dbus
    //QString isVokoscreenLoaded();

    void stateChangedshortcutsOnOff( int );
  
    
private slots:

  void addVokoscreenExtensions();
  void extensionLoadpushButtonClicked();

  void closeEvent( QCloseEvent * event );
  
  void addLogVokoscreen( QString value );
  void VisibleHideKonsole();
  void myScreenCountChanged( int newCount );
  void showMagnifier();
  void uncheckMagnifier();
  void searchExternalPrograms();
  bool searchProgramm( QString ProgName );
  QString getFfmpegVersion();
  QString getPactlVersion();
  QString getXdgemailVersion();
  QString getLsofVersion();  
  void AudioOff( int state );
  void AlsaWatcherEvent( QStringList CardxList );
  void PulseMultipleChoice();
  QCheckBox *getCheckBoxPulseDevice( int value );
  void AudioOnOff();
  void WindowMinimized();
  void saveSettings();
  void debugCommandInvocation(const QString &description, const QString &program,
			      const QStringList arguments, const QString &suffix=QString());

  void areaReset();

  void setRecordWidth( QString value );
  QString getRecordWidth();
  void setRecordHeight( QString value );
  QString getRecordHeight();
  
  void stateChangedAudio( int state );
  void clickedAudioAlsa( bool checked );
  void clickedAudioPulse( bool checked );
  void valueChangedFrames( int i );
  void clickedScreenSize();
  
  void currentIndexChangedCodec( int index );
  void currentIndexChangedFormat( int index );
  
  void windowMove();
  void newMovedXYcoordinates();

  // Tab Videooptionen
  void setFrameStandardSpinbox();
  void setVideocodecStandardComboBox();
  void setAudiocodecStandardComboBox();

  void searchGIFPlayer();
  void searchVideoPlayer();
  
  void currentFormatChanged( const QString value );
  
  // Tab  Verschiedenes
  QString PathMoviesLocation();
  void saveVideoPath();
  void myVideoFileSystemWatcher( const QString & path );
  QString getFileWithPath( QString ProgName );
  void recorderLineEditTextChanged( QString recorder );
  void selectRecorder();
  void showCredits();
  void creditsCloseEvent();
  void stateChangedSystray( int state );

  void searchVideoCodec( QStringList videoCodecList );
  void searchAudioCodec( QStringList audioCodecList );
  void SearchFormats();

  
  QString PathTempLocation();
  QString NameInMoviesLocation();
  QString newPauseNameInTmpLocation();
  QStringList myAlsa();
  QStringList myAcodec();
  void AreaOnOff();
  void preRecord();
  void Countdown();
  void record();
  void startRecord(QString RecordPathName, QString x, QString Y);
  void Stop();
  void Pause();
  void play();
  void send();

  void error ( QProcess::ProcessError error );
  void readyReadStandardError();
  void stateChanged( QProcess::ProcessState newState );
  
  //void ShortcutPause();
  
  void SystemTrayKontextMenue( QAction *action );
  
  void copyToClipboard();
  
  // shortcutStart
  // void setShortcutsOnOff( int );
  // void shortcut_magnifier_Changed( int value );

#ifndef NO_NEW_VERSION_CHECK
    void buttonVersion();
#endif
  void showHomepage();
    
private:
    QString DISPLAY;
    QString WAYLAND_DISPLAY;
    QString XDG_RUNTIME_DIR;
    
    QvkSettings vkSettings;
    Ui_screencast  myUi;
    int oldMainWindowHeight;
    QvkMagnifier *magnifier;
    QvkRegionController *myregionselection;
    
    QvkShowClickDialog *ShowClickDialog;
    QvkAnimateControl *animateControl;
    QList<QvkAlsaDevice *> AlsaCardList;

    QScrollArea *scrollAreaPulse;
    QCheckBox *namePulse;
    
    QLabel *statusBarLabelTime;
    QLabel * statusBarLabelFps;
    QLabel * statusBarLabelSize;
    QLabel * statusBarLabelCodec;
    QLabel * statusBarLabelFormat;
    QLabel * statusBarLabelAudio;
    QLabel * statusBarLabelFpsSettings;
    QLabel * statusbarLabelScreenSize;
    QLabel * statusBarProgForRecord;
    
    QString screenRecordWidth;
    QString screenRecordHeight;

    QMenu *SystemTrayMenu;
    QSystemTrayIcon *SystemTrayIcon;
    QAction *startAction;
    QAction *stopAction;
    QAction *pauseAction;
    QAction *goAction;
    QAction *hideAction;
    QAction *exitAction;
    
    QvkWebcamController *webcamController;

    QvkCredits *credits;
    
    QvkWinInfo *vkWinInfo;
    WId moveWindowID;
    
    QxtGlobalShortcut *shortcutWebcam;
    QxtGlobalShortcut *shortcutMagnifier;
    QxtGlobalShortcut *shortcutPause;
    QxtGlobalShortcut *shortcutStart;
    QxtGlobalShortcut *shortcutStop;
    
    QTimer *windowMoveTimer;
    QDateTime beginTime;

    bool pause;
    
    QFileSystemWatcher *VideoFileSystemWatcher;
    
    QvkFormatsAndCodecs *formatsAndCodecs;
    QString getFfmpegVersionFullOutput();
    
    void makeAndSetValidIcon( int index );

    QvkAlsaWatcher *myAlsaWatcher;

signals:

  
protected:
   void contextMenuEvent( QContextMenuEvent *event );
   void showEvent(QShowEvent *event);

};


#endif // screencast_H
