/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
**
** This version of "lempar.c" is modified, slightly, for use by SQLite.
** The only modifications are the addition of a couple of NEVER()
** macros to disable tests that are needed in the case of a general
** LALR(1) grammar but which are always false in the
** specific grammar used by SQLite.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>

#include "token.h"
#include "parsercontext.h"
#include "parser_helper_stubs.h"
#include "common/utils_sql.h"
#include "parser/ast/sqlitealtertable.h"
#include "parser/ast/sqliteanalyze.h"
#include "parser/ast/sqliteattach.h"
#include "parser/ast/sqlitebegintrans.h"
#include "parser/ast/sqlitecommittrans.h"
#include "parser/ast/sqlitecopy.h"
#include "parser/ast/sqlitecreateindex.h"
#include "parser/ast/sqlitecreatetable.h"
#include "parser/ast/sqlitecreatetrigger.h"
#include "parser/ast/sqlitecreateview.h"
#include "parser/ast/sqlitecreatevirtualtable.h"
#include "parser/ast/sqlitedelete.h"
#include "parser/ast/sqlitedetach.h"
#include "parser/ast/sqlitedropindex.h"
#include "parser/ast/sqlitedroptable.h"
#include "parser/ast/sqlitedroptrigger.h"
#include "parser/ast/sqlitedropview.h"
#include "parser/ast/sqliteemptyquery.h"
#include "parser/ast/sqliteinsert.h"
#include "parser/ast/sqlitepragma.h"
#include "parser/ast/sqlitereindex.h"
#include "parser/ast/sqliterelease.h"
#include "parser/ast/sqliterollback.h"
#include "parser/ast/sqlitesavepoint.h"
#include "parser/ast/sqliteselect.h"
#include "parser/ast/sqliteupdate.h"
#include "parser/ast/sqlitevacuum.h"
#include "parser/ast/sqliteexpr.h"
#include "parser/ast/sqlitecolumntype.h"
#include "parser/ast/sqliteconflictalgo.h"
#include "parser/ast/sqlitesortorder.h"
#include "parser/ast/sqliteindexedcolumn.h"
#include "parser/ast/sqliteforeignkey.h"
#include "parser/ast/sqlitewith.h"
#include <QObject>
#include <QDebug>
#include <limits.h>

#define assert(X) Q_ASSERT(X)
#define UNUSED_PARAMETER(X) (void)(X)
#define DONT_INHERIT_TOKENS(X) noTokenInheritanceFields << X
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/*
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands.
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3_parseTOKENTYPE     is the data type used for minor tokens given
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3_parseTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlite3_parseARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3_parseARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3_parseARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3_parseARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned short int
#define YYNOCODE 278
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 61
#define sqlite3_parseTOKENTYPE Token*
typedef union {
  int yyinit;
  sqlite3_parseTOKENTYPE yy0;
  SqliteCreateTable::Column::Constraint* yy4;
  SqliteCreateTable::Constraint* yy8;
  ParserExprList* yy13;
  QVariant* yy21;
  ParserStubAlias* yy28;
  SqliteConflictAlgo* yy30;
  ParserFullName* yy66;
  ParserCreateTableConstraintList* yy87;
  SqliteIndexedColumn* yy90;
  ParserFkConditionList* yy108;
  SqliteSelect::Core::JoinConstraint* yy117;
  ParserCreateTableColumnList* yy118;
  SqliteSelect* yy123;
  SqliteLimit* yy128;
  ParserDeferSubClause* yy131;
  ParserIndexedColumnList* yy139;
  SqliteCreateTrigger::Time* yy152;
  SqliteSelect::CompoundOperator* yy168;
  SqliteSelect::Core::SingleSource* yy173;
  QString* yy211;
  ParserQueryList* yy214;
  ParserStubExplain* yy225;
  SqliteSortOrder* yy226;
  bool* yy237;
  ParserStubInsertOrReplace* yy250;
  ParserResultColumnList* yy263;
  SqliteForeignKey::Condition* yy271;
  SqliteColumnType* yy299;
  ParserStubTransDetails* yy300;
  SqliteCreateTrigger::Event* yy309;
  SqliteForeignKey::Condition::Reaction* yy312;
  ParserOtherSourceList* yy359;
  SqliteWith* yy367;
  SqliteSelect::Core::JoinSource* yy373;
  SqliteExpr::LikeOp* yy374;
  int* yy376;
  ParserSetValueList* yy381;
  SqliteQuery* yy399;
  SqliteCreateTrigger::Scope* yy409;
  ParserExprNestedList* yy416;
  SqliteCreateTable::Column* yy425;
  ParserStringList* yy445;
  ParserCreateTableColumnConstraintList* yy449;
  SqliteSelect::Core* yy468;
  ParserIndexedBy* yy472;
  SqliteSelect::Core::JoinOp* yy473;
  SqliteExpr* yy490;
  ParserOrderByList* yy495;
  SqliteInitially* yy498;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlite3_parseARG_SDECL ParserContext* parserContext;
#define sqlite3_parseARG_PDECL ,ParserContext* parserContext
#define sqlite3_parseARG_FETCH ParserContext* parserContext = yypParser->parserContext
#define sqlite3_parseARG_STORE yypParser->parserContext = parserContext
#define YYNSTATE 724
#define YYNRULE 424
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

#define GET_CONTEXT yyParser* yypParser = pParser; sqlite3_parseARG_FETCH

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor = { 0 };

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
#define YY_ACTTAB_COUNT (2263)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   431,   48,   48,   47,   47,   47,   46,  216,  716,  339,
 /*    10 */   643,  425,   51,   51,   51,   51,   44,   49,   49,   49,
 /*    20 */    49,   48,   48,   47,   47,   47,   46,  216,  721, 1026,
 /*    30 */  1026,  643,  131,  580,   51,   51,   51,   51,  411,   49,
 /*    40 */    49,   49,   49,   48,   48,   47,   47,   47,   46,  216,
 /*    50 */   579,   81,   58,  643,  157,  685,  301,  282, 1026, 1026,
 /*    60 */    41, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026,
 /*    70 */  1026, 1026,  563, 1026, 1026, 1026, 1026,   38,   39, 1026,
 /*    80 */  1026, 1026, 1026, 1026,   40,  431,  528,  385,  716,  595,
 /*    90 */   594,  280,    4,  377,  716,  630,  425,  642,  608,  422,
 /*   100 */    12,  134,  687,  429,  562,  609,  483,  690,  331,  279,
 /*   110 */   714,  713,  564,  565,  642,  689,  688,  687,  235,  506,
 /*   120 */    60,  320,  610,  411,   47,   47,   47,   46,  216,  122,
 /*   130 */   243,  213,  247,   59, 1142, 1142,  486,  609,  607,  603,
 /*   140 */   685,  306,  485,  584,  716,   41,  507,  509,  642,  508,
 /*   150 */   676,    9,  642,  144,   95,  281,  379,  276,  378,  132,
 /*   160 */   297,  716,   38,   39,  601,  200,  199,    7,  355,   40,
 /*   170 */   884,  307, 1134,  274,  249,  716,   17,    4,  884, 1134,
 /*   180 */    56,  717,  642,  431,  422,  884,  329,  687,  429,  716,
 /*   190 */   687,  643,  690,  687,  425,  690,  714,  713,  690,  642,
 /*   200 */   689,  688,  687,  689,  688,  687,  689,  688,  687,   98,
 /*   210 */   682,  240,  643,  218,  410,  884,  486,  884,  884,  483,
 /*   220 */   716,  411,  239,  884,  303,  582,  512,  581,  884,  884,
 /*   230 */   884,  884,  884,  642,  643,  676,    9,  642,  685,  217,
 /*   240 */   245,  673,  102,   41,  287,  300,  714,  713,   67,  302,
 /*   250 */   148,  307, 1133,  151,  306,  484,   81,  715,   97, 1133,
 /*   260 */    38,   39,  551,  714,  713,  771,  130,   40,  946,  376,
 /*   270 */   373,  372,  447,   46,  216,    4,  946,  714,  713,  334,
 /*   280 */   642,  682,  422,  946,  606,  687,  429,  371,  448,  447,
 /*   290 */   690,  714,  713,  304,  265,  146,  267,  642,  689,  688,
 /*   300 */   687,  287,   68,  677,  691,  255,  362,  259,  359,  692,
 /*   310 */  1027, 1027,  682,  946,  715,  946,  946,  447,  698,  234,
 /*   320 */   386,  715,  714,  713,  773,  651,  946,  946,  946,  946,
 /*   330 */   110,  642,  317,  676,    9,  642,  222,  677,  299,   52,
 /*   340 */    53,  426,  289, 1027, 1027,  675,  675,   50,   50,   51,
 /*   350 */    51,   51,   51,  716,   49,   49,   49,   49,   48,   48,
 /*   360 */    47,   47,   47,   46,  216,  431,  428,  340,  716,  335,
 /*   370 */   671,  670,  287,  283,  716,  138,  425,  209,  219,  430,
 /*   380 */   268,  395,  651,  682,  336,  715,  715,  686,  187,   52,
 /*   390 */    53,  426,  289,  715,  452,  675,  675,   50,   50,   51,
 /*   400 */    51,   51,   51,  411,   49,   49,   49,   49,   48,   48,
 /*   410 */    47,   47,   47,   46,  216,   91,  953,  716,  619,  712,
 /*   420 */   685,  403,  382,  130,  710,   41,  376,  373,  372,  711,
 /*   430 */   233,  953,  394,  311,  210,  593,  666,  384,  428,   16,
 /*   440 */   316,  659,   38,   39,  371,  231,  230,  716,   89,   40,
 /*   450 */   931,  430,  716,  658,  716,  714,  713,    4,  931,  686,
 /*   460 */    92,  143,  642,  358,  422,  931,  674,  687,  429,   14,
 /*   470 */   714,  713,  690,  131,  456,  551,  714,  713,  953,  642,
 /*   480 */   689,  688,  687,  668,  667,  210,  593,  458,  384,  457,
 /*   490 */   576,   88, 1027, 1027,   13,  931,  672,  931,  931,   54,
 /*   500 */   575,  678,   42,  368,   37,  401,   35,  381,  931,    1,
 /*   510 */   931,  931,  641,  642,  634,  676,    9,  642,  661,  714,
 /*   520 */   713,   52,   53,  426,  289, 1027, 1027,  675,  675,   50,
 /*   530 */    50,   51,   51,   51,   51,  660,   49,   49,   49,   49,
 /*   540 */    48,   48,   47,   47,   47,   46,  216,  657,  648,  714,
 /*   550 */   713,  496,  542,  569,  714,  713,  714,  713,  656,  691,
 /*   560 */   543,  614,  320,   30,  692,   27,  716,  585,  274,  682,
 /*   570 */   160, 1027, 1027,  426,  289,  693,  613,  675,  675,   50,
 /*   580 */    50,   51,   51,   51,   51,  398,   49,   49,   49,   49,
 /*   590 */    48,   48,   47,   47,   47,   46,  216, 1025, 1025,   81,
 /*   600 */    52,   53,  426,  289, 1027, 1027,  675,  675,   50,   50,
 /*   610 */    51,   51,   51,   51,  496,   49,   49,   49,   49,   48,
 /*   620 */    48,   47,   47,   47,   46,  216, 1025, 1025, 1025, 1025,
 /*   630 */  1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025,
 /*   640 */   716, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025, 1025,
 /*   650 */  1025, 1025, 1027, 1027,  357,   49,   49,   49,   49,   48,
 /*   660 */    48,   47,   47,   47,   46,  216,  288,  552,  714,  713,
 /*   670 */   495,  682,  298,  662,  346,  153,  538,   69,  694,  715,
 /*   680 */   715,   52,   53,  426,  289, 1027, 1027,  675,  675,   50,
 /*   690 */    50,   51,   51,   51,   51, 1094,   49,   49,   49,   49,
 /*   700 */    48,   48,   47,   47,   47,   46,  216,   52,   53,  426,
 /*   710 */   289,  418,  511,  675,  675,   50,   50,   51,   51,   51,
 /*   720 */    51,  159,   49,   49,   49,   49,   48,   48,   47,   47,
 /*   730 */    47,   46,  216,  490,  954,  315,  482,  482,  663,  553,
 /*   740 */   215,  650,  714,  713,   81,   52,   53,  426,  289,  954,
 /*   750 */   414,  675,  675,   50,   50,   51,   51,   51,   51,  397,
 /*   760 */    49,   49,   49,   49,   48,   48,   47,   47,   47,   46,
 /*   770 */   216,  158, 1094,   21,  716,  627,  459,  716, 1079,  716,
 /*   780 */   647, 1045,  140,   89,  716, 1149,  154,  435,    2,  715,
 /*   790 */   424,  671,  670,  396,  460,  461,  954,   52,   53,  426,
 /*   800 */   289,  573,  716,  675,  675,   50,   50,   51,   51,   51,
 /*   810 */    51,  321,   49,   49,   49,   49,   48,   48,   47,   47,
 /*   820 */    47,   46,  216,  431, 1108,   81,  206,  205,  204,   52,
 /*   830 */    53,  426,  289,  716,  425,  675,  675,   50,   50,   51,
 /*   840 */    51,   51,   51,  344,   49,   49,   49,   49,   48,   48,
 /*   850 */    47,   47,   47,   46,  216,  597,  715,  666,  600,  462,
 /*   860 */   666,  411,   31,  716,  657,   90,   12,  894,  720,  668,
 /*   870 */   667,  609,  724,  434,   81,  656,  714,  713,  685,  714,
 /*   880 */   713,  714,  713,   41,  528,  272,  714,  713,  610,  349,
 /*   890 */   528,  450,   89,  677,   12,  633,  633,  338,  636,  609,
 /*   900 */    38,   39,  649,  609,  714,  713,  716,   40, 1142, 1142,
 /*   910 */   716,  524,  682,  581,  716,    4,  610,  468,   60,  450,
 /*   920 */   642,  208,  422,  506,   60,  687,  429,  677,   32,  109,
 /*   930 */   690,  609,  500,  501,  352,  714,  713,  642,  689,  688,
 /*   940 */   687,  428,  900,  900,  467,  466,  552,  465,  421,  383,
 /*   950 */   507,  509,  142,  508,  430,  440,   69, 1142, 1142,  715,
 /*   960 */   444,  722,  686,  182,  646,  714,  713,  645,  231,  230,
 /*   970 */   437,  642,  356,  676,    9,  642,  417,  444,   52,   53,
 /*   980 */   426,  289,   91,   91,  675,  675,   50,   50,   51,   51,
 /*   990 */    51,   51,  644,   49,   49,   49,   49,   48,   48,   47,
 /*  1000 */    47,   47,   46,  216, 1034,  444,  668,  667,  714,  713,
 /*  1010 */    91,  453,  714,  713,  682,  641,  714,  713,  324,  202,
 /*  1020 */    52,   53,  426,  289,  446,  680,  675,  675,   50,   50,
 /*  1030 */    51,   51,   51,   51,  639,   49,   49,   49,   49,   48,
 /*  1040 */    48,   47,   47,   47,   46,  216,  605,   52,   53,  426,
 /*  1050 */   289,  716,  446,  675,  675,   50,   50,   51,   51,   51,
 /*  1060 */    51,  459,   49,   49,   49,   49,   48,   48,   47,   47,
 /*  1070 */    47,   46,  216,  453,  715,   36,  663,  423,  215,  460,
 /*  1080 */   341,  369,  592,   52,   53,  426,  289,  638,   89,  675,
 /*  1090 */   675,   50,   50,   51,   51,   51,   51,   31,   49,   49,
 /*  1100 */    49,   49,   48,   48,   47,   47,   47,   46,  216,  413,
 /*  1110 */   723,    2,   11,   52,   53,  426,  289,   33,  588,  675,
 /*  1120 */   675,   50,   50,   51,   51,   51,   51,  624,   49,   49,
 /*  1130 */    49,   49,   48,   48,   47,   47,   47,   46,  216,  515,
 /*  1140 */   715,  537,   29,   91,  342,  666,  140,  136,  571,   52,
 /*  1150 */    53,  426,  289,  714,  713,  675,  675,   50,   50,   51,
 /*  1160 */    51,   51,   51,  548,   49,   49,   49,   49,   48,   48,
 /*  1170 */    47,   47,   47,   46,  216,   91,  716,  234,  386,   52,
 /*  1180 */    53,  426,  289,  338,  271,  675,  675,   50,   50,   51,
 /*  1190 */    51,   51,   51,  333,   49,   49,   49,   49,   48,   48,
 /*  1200 */    47,   47,   47,   46,  216,  532,    8,  517,  696,   87,
 /*  1210 */   137,   52,   53,  426,  289,   22,  557,  675,  675,   50,
 /*  1220 */    50,   51,   51,   51,   51,  135,   49,   49,   49,   49,
 /*  1230 */    48,   48,   47,   47,   47,   46,  216,   81, 1109,   91,
 /*  1240 */   716,   91,   52,   53,  426,  289,  615,  722,  675,  675,
 /*  1250 */    50,   50,   51,   51,   51,   51,  620,   49,   49,   49,
 /*  1260 */    49,   48,   48,   47,   47,   47,   46,  216,  604, 1107,
 /*  1270 */    99,  504,  390,  491,   52,   53,  426,  289,  714,  713,
 /*  1280 */   675,  675,   50,   50,   51,   51,   51,   51,  682,   49,
 /*  1290 */    49,   49,   49,   48,   48,   47,   47,   47,   46,  216,
 /*  1300 */   226,   52,   57,  426,  289,  599,  388,  675,  675,   50,
 /*  1310 */    50,   51,   51,   51,   51,  428,   49,   49,   49,   49,
 /*  1320 */    48,   48,   47,   47,   47,   46,  216,  431,  430,    5,
 /*  1330 */    10,  620,  620,  632,  491,  631,  686,  187,  425,   53,
 /*  1340 */   426,  289,  714,  713,  675,  675,   50,   50,   51,   51,
 /*  1350 */    51,   51,  716,   49,   49,   49,   49,   48,   48,   47,
 /*  1360 */    47,   47,   46,  216,  552,  411,  598,  107,  464,  591,
 /*  1370 */   403,  387,  428,  697,   69,  612,  611,  715,  428,  716,
 /*  1380 */   404,  715,  685,  716,  209,  430,  209,   41,  625,  316,
 /*  1390 */   682,  430,  596,  686,  187,  428,  223,  590,  539,  686,
 /*  1400 */   187,  653,  287,  716,   38,   39,  589,  225,  430,  718,
 /*  1410 */   431,   40,  620,  716,   91,  715,  686,  187,  252,    4,
 /*  1420 */   570,  425,  715,   19,  642,   89,  422,  403,  405,  687,
 /*  1430 */   429,  716,  624,  332,  690,  716,  428,  328,  716,  705,
 /*  1440 */   716,  642,  689,  688,  687,  715,  316,  266,  411,  430,
 /*  1450 */   561,  365,  316,  716,  714,  713,  602,  686,  187,  488,
 /*  1460 */   715,  829,  716,  375,   65,  685,  308,  682,  540,  406,
 /*  1470 */    41,  706,  285,  209,  273,  642,  475,  676,    9,  642,
 /*  1480 */   530,  714,  713,  651,  715,  714,  713,   38,   39,   64,
 /*  1490 */    18,  399,  370,  431,   40,  129,  716,  366,  326,  534,
 /*  1500 */   534,   63,    4,  270,  425,  714,  713,  642,  475,  422,
 /*  1510 */   316,  530,  687,  429,  716,  714,  713,  690,  279,  716,
 /*  1520 */   533,  716,  156,  624,  642,  689,  688,  687,  525,  716,
 /*  1530 */   125,  411,  519,  714,  713,  514,  715,  714,  713,    3,
 /*  1540 */   714,  713,  714,  713,   79,  525,  682,   85,  685,  519,
 /*  1550 */   479,   26,  514,   41,   25,  714,  713,  516,  642,  472,
 /*  1560 */   676,    9,  642,  716,  714,  713,  407,  479,  716,  682,
 /*  1570 */    38,   39,  353,   77,  286,  431,  510,   40,  283,  505,
 /*  1580 */   555,  428,  616,  503,   83,    4,  425,  715,  140,  351,
 /*  1590 */   642,  715,  422,  469,  430,  687,  429,  716,  714,  713,
 /*  1600 */   690,  716,  686,  192,  472,  428,  703,  642,  689,  688,
 /*  1610 */   687,  438,  428,  411,  497,   62,  714,  713,  430,  119,
 /*  1620 */   254,  714,  713,  714,  713,  430,  686,  181,  438,  704,
 /*  1630 */   685,  714,  713,  686,  163,   41,  251,  629,  311,  161,
 /*  1640 */   138,  642,  715,  676,    9,  642,  455, 1035,  682,  531,
 /*  1650 */   701,  702,   38,   39,  152,  641,  498,  469,  431,   40,
 /*  1660 */   499,  478,  699,  428,  715,  714,  713,    4, 1037,  425,
 /*  1670 */   714,  713,  642,  416,  422,  715,  430,  687,  429,  641,
 /*  1680 */   428,  350,  690,  619,  686,  172,  641,  494,  454,  642,
 /*  1690 */   689,  688,  687,  430,  111,  428,  411,  716,   72,  714,
 /*  1700 */   713,  686,  190,  714,  713,  621,  287,  337,  430,  428,
 /*  1710 */   436,  428,   96,  685,  209,  558,  686,  188,   41,  715,
 /*  1720 */   567,  287,  430,  642,  430,  676,    9,  642,  716,  207,
 /*  1730 */   686,  196,  686,  195,  715,   38,   39,  641,  716,  286,
 /*  1740 */   431,  327,   40,  224,   86,  428,  695,  319,  203,  428,
 /*  1750 */     4,  425,  715,  318,  641,  642,  325,  422,  430,  715,
 /*  1760 */   687,  429,  430,  150,  261,  690,  686,  197,  221,  641,
 /*  1770 */   686,  201,  642,  689,  688,  687,  428,  715,  411,  716,
 /*  1780 */   719,  709,  708,  641,  433,  641,  707,  651,  258,  430,
 /*  1790 */   428,  283,  220,  536,  428,  685,  149,  686,  232,  714,
 /*  1800 */   713,  715,  651,  430,  715,  147,  642,  430,  676,    9,
 /*  1810 */   642,  686,  290,  428,   82,  686,  191,   38,   39,  641,
 /*  1820 */   679,  367,  432,  641,   40,   15,  430,  145,  700,  234,
 /*  1830 */   714,  713,    4,  715,  686,  194,  408,  642,  420,  422,
 /*  1840 */   714,  713,  687,  429,  716,  428,  684,  690,  637,  715,
 /*  1850 */   641,  227,  428,  294,  642,  689,  688,  687,  430,  716,
 /*  1860 */   293,  715,  428,   17,  641,  430,  686,  193,  641,  292,
 /*  1870 */   400,  291,  402,  686,  185,  430,  521,   28,  683,   55,
 /*  1880 */   428,  714,  713,  686,  189,   43,  428,  641,  642,  640,
 /*  1890 */   676,    9,  642,  430,  216,  419,  428,   66,  529,  430,
 /*  1900 */   428,  686,  314,  428,  229,  214,  228,  686,  313,  430,
 /*  1910 */   428,  415,   34,  430,  141,  626,  430,  686,  312,  641,
 /*  1920 */   428,  686,  184,  430,  686,  171,  641,  428,  715,  635,
 /*  1930 */   139,  686,  170,  430,  108,  386,  641,  716,  463,  622,
 /*  1940 */   430,  686,  183,  428,  617,  428,  714,  713,  686,  169,
 /*  1950 */   428,  716,  715,  389,  641,  583,  430,  715,  430,  380,
 /*  1960 */   641,  714,  713,  430,  686,  186,  686,  168,  428,  716,
 /*  1970 */   641,  686,  167,  541,  641,  428,  578,  641,  716,  257,
 /*  1980 */   133,  430,  577,  256,  641,  428,  474,  428,  430,  686,
 /*  1990 */    93,  428,  715,  715,  641,  716,  686,  166,  430,  716,
 /*  2000 */   430,  641,  330,  716,  430,  716,  686,  164,  686,  174,
 /*  2010 */   428,  277,  686,  173,  393,  428,  275,  641,  716,  641,
 /*  2020 */   716,  568,  574,  430,  641,  428,  573,  715,  430,  715,
 /*  2030 */   428,  686,  175,  489,  715,  428,  686,  178,  430,  714,
 /*  2040 */   713,  572,  641,  430,  716,  428,  686,   94,  430,  641,
 /*  2050 */   310,  686,  177,  714,  713,  128,  686,  176,  430,  641,
 /*  2060 */   554,  641,  549,  716,  428,  641,  686,  180,  716,  428,
 /*  2070 */   716,  714,  713,  716,  392,  715,  547,  430,  546,  545,
 /*  2080 */   714,  713,  430,  502,  641,  686,  179,  430,  544,  641,
 /*  2090 */   686,  165,  527,  309,   80,  686,   70,  714,  713,  641,
 /*  2100 */   535,  714,  713,  269,  641,  714,  713,  714,  713,  641,
 /*  2110 */   127,  106,  471,  523,  248,  263,  715,  518,  481,  641,
 /*  2120 */   714,  713,  714,  713,  476,  212,  246,  715,  715,  244,
 /*  2130 */   477,  126,  492,  473,  480,  262,  242,  354,  641,  715,
 /*  2140 */   470,  236,  715,  641,  360,  322,  714,  713,  641,  715,
 /*  2150 */   347,  363,   24,  652,  715,  442,  427,  715,  443,  441,
 /*  2160 */   124,  284,  526,  715,  648,  714,  713,  264,  715,  715,
 /*  2170 */   714,  713,  714,  713,  715,  714,  713,  253,   78,  250,
 /*  2180 */   715,  241,  237,  238,  105,  123,  121,   84,  104,  155,
 /*  2190 */   715,  513,  715,  120,  715,  715,  715,  493,  348,  103,
 /*  2200 */   118,  345,   76,  343,  117,   75,  116,  115,  114,   74,
 /*  2210 */    73,  113,   23,  323,  451,  101,   20,  100,  623,  112,
 /*  2220 */    61,  520,  449,  445,  439,  655,  628,  162,  278,  669,
 /*  2230 */   665,  412,  569,  295,  681,  198,  374,  522,  618,  260,
 /*  2240 */   361,    6,  305,  664,  654,  556,  364,  409,  566,  211,
 /*  2250 */   296,   71,  560,  559,  487,  587,  586,   81,  550, 1150,
 /*  2260 */  1150, 1150,   45,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */     4,   81,   82,   83,   84,   85,   86,   87,    4,   58,
 /*    10 */     5,   15,   72,   73,   74,   75,   76,   77,   78,   79,
 /*    20 */    80,   81,   82,   83,   84,   85,   86,   87,   89,   33,
 /*    30 */    34,   26,   34,   28,   72,   73,   74,   75,   42,   77,
 /*    40 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*    50 */    45,   55,   96,   48,   98,   59,   93,  104,   62,   63,
 /*    60 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*    70 */    74,   75,   14,   77,   78,   79,   80,   81,   82,   83,
 /*    80 */    84,   85,   86,   87,   88,    4,  185,  134,    4,  136,
 /*    90 */   137,  111,   96,   35,    4,  104,   15,  101,  104,  103,
 /*   100 */    96,  107,  106,  107,   46,  101,   61,  111,   64,  129,
 /*   110 */   106,  107,  110,  111,  118,  119,  120,  121,  167,  218,
 /*   120 */   219,  123,  118,   42,   83,   84,   85,   86,   87,  104,
 /*   130 */    51,   87,   53,  142,  138,  139,   61,  133,  144,  145,
 /*   140 */    59,   96,   97,   59,    4,   64,  245,  246,  152,  248,
 /*   150 */   154,  155,  156,  109,  110,  111,  112,  113,  114,  115,
 /*   160 */    97,    4,   81,   82,   83,   81,   82,  266,  267,   88,
 /*   170 */    89,   96,   97,  129,   95,    4,  151,   96,   97,  104,
 /*   180 */    96,   91,  101,    4,  103,  104,  128,  106,  107,    4,
 /*   190 */   106,    5,  111,  106,   15,  111,  106,  107,  111,  118,
 /*   200 */   119,  120,  121,  119,  120,  121,  119,  120,  121,    8,
 /*   210 */     4,   10,   26,   12,   28,  134,   61,  136,  137,   61,
 /*   220 */     4,   42,   21,  142,   23,  214,   45,  216,  147,  148,
 /*   230 */   149,  150,  151,  152,   48,  154,  155,  156,   59,   96,
 /*   240 */   161,   97,   41,   64,  177,   44,  106,  107,  104,   48,
 /*   250 */    49,   96,   97,   52,   96,   97,   55,  190,   57,  104,
 /*   260 */    81,   82,  105,  106,  107,   99,  109,   88,   89,  112,
 /*   270 */   113,  114,  101,   86,   87,   96,   97,  106,  107,  212,
 /*   280 */   101,    4,  103,  104,  144,  106,  107,  130,  117,  118,
 /*   290 */   111,  106,  107,   92,   51,   94,   53,  118,  119,  120,
 /*   300 */   121,  177,   96,  118,  135,  124,  125,  126,  177,  140,
 /*   310 */    33,   34,  106,  134,  190,  136,  137,  146,  102,  138,
 /*   320 */   139,  190,  106,  107,   99,  258,  147,  148,  149,  150,
 /*   330 */    99,  152,  131,  154,  155,  156,  212,  152,   95,   62,
 /*   340 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   350 */    73,   74,   75,    4,   77,   78,   79,   80,   81,   82,
 /*   360 */    83,   84,   85,   86,   87,    4,  177,  166,    4,  194,
 /*   370 */   195,  196,  177,  177,    4,   98,   15,  252,  247,  190,
 /*   380 */   177,  185,  258,  106,  181,  190,  190,  198,  199,   62,
 /*   390 */    63,   64,   65,  190,  269,   68,   69,   70,   71,   72,
 /*   400 */    73,   74,   75,   42,   77,   78,   79,   80,   81,   82,
 /*   410 */    83,   84,   85,   86,   87,  219,   89,    4,  141,   19,
 /*   420 */    59,  232,  233,  109,   24,   64,  112,  113,  114,   29,
 /*   430 */   225,  104,  236,  237,  220,  221,  261,  223,  177,  234,
 /*   440 */   251,   97,   81,   82,  130,   81,   82,    4,  104,   88,
 /*   450 */    89,  190,    4,  258,    4,  106,  107,   96,   97,  198,
 /*   460 */   199,   99,  101,  249,  103,  104,  111,  106,  107,   71,
 /*   470 */   106,  107,  111,   34,  110,  105,  106,  107,  151,  118,
 /*   480 */   119,  120,  121,  119,  120,  220,  221,  123,  223,  125,
 /*   490 */    19,   43,   33,   34,   96,  134,   97,  136,  137,   40,
 /*   500 */    29,  152,   96,   64,  158,  244,  160,   83,  147,   96,
 /*   510 */   149,  150,  251,  152,  101,  154,  155,  156,   97,  106,
 /*   520 */   107,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   530 */    71,   72,   73,   74,   75,   97,   77,   78,   79,   80,
 /*   540 */    81,   82,   83,   84,   85,   86,   87,    9,  100,  106,
 /*   550 */   107,  101,  205,  206,  106,  107,  106,  107,   20,  135,
 /*   560 */   213,  118,  123,  104,  140,  123,    4,  190,  129,    4,
 /*   570 */    96,   33,   34,   64,   65,  198,  133,   68,   69,   70,
 /*   580 */    71,   72,   73,   74,   75,  143,   77,   78,   79,   80,
 /*   590 */    81,   82,   83,   84,   85,   86,   87,   33,   34,   55,
 /*   600 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   610 */    72,   73,   74,   75,  164,   77,   78,   79,   80,   81,
 /*   620 */    82,   83,   84,   85,   86,   87,   62,   63,   64,   65,
 /*   630 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   640 */     4,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   650 */    86,   87,   33,   34,  110,   77,   78,   79,   80,   81,
 /*   660 */    82,   83,   84,   85,   86,   87,  177,  177,  106,  107,
 /*   670 */    50,  106,  182,  108,   54,  104,  186,  187,  116,  190,
 /*   680 */   190,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   690 */    71,   72,   73,   74,   75,   12,   77,   78,   79,   80,
 /*   700 */    81,   82,   83,   84,   85,   86,   87,   62,   63,   64,
 /*   710 */    65,   98,   23,   68,   69,   70,   71,   72,   73,   74,
 /*   720 */    75,   96,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   730 */    85,   86,   87,  113,   89,  188,  100,  101,  191,  192,
 /*   740 */   193,   97,  106,  107,   55,   62,   63,   64,   65,  104,
 /*   750 */    98,   68,   69,   70,   71,   72,   73,   74,   75,   30,
 /*   760 */    77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   770 */    87,   96,   89,   38,    4,   97,  177,    4,   89,    4,
 /*   780 */    23,  161,  104,  104,    4,  170,  171,  172,  173,  190,
 /*   790 */   194,  195,  196,   64,  195,  196,  151,   62,   63,   64,
 /*   800 */    65,  122,    4,   68,   69,   70,   71,   72,   73,   74,
 /*   810 */    75,  179,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   820 */    85,   86,   87,    4,   89,   55,  124,  125,  126,   62,
 /*   830 */    63,   64,   65,    4,   15,   68,   69,   70,   71,   72,
 /*   840 */    73,   74,   75,  177,   77,   78,   79,   80,   81,   82,
 /*   850 */    83,   84,   85,   86,   87,   97,  190,  261,   83,  260,
 /*   860 */   261,   42,  104,    4,    9,   98,   96,   97,  169,  119,
 /*   870 */   120,  101,    0,  174,   55,   20,  106,  107,   59,  106,
 /*   880 */   107,  106,  107,   64,  185,   97,  106,  107,  118,  257,
 /*   890 */   185,  118,  104,  118,   96,   33,   34,   25,  118,  101,
 /*   900 */    81,   82,   97,  133,  106,  107,    4,   88,  138,  139,
 /*   910 */     4,  214,    4,  216,    4,   96,  118,  218,  219,  146,
 /*   920 */   101,   96,  103,  218,  219,  106,  107,  152,   66,   67,
 /*   930 */   111,  133,  124,  125,  126,  106,  107,  118,  119,  120,
 /*   940 */   121,  177,  144,  145,  245,  246,  177,  248,  185,  185,
 /*   950 */   245,  246,  104,  248,  190,  186,  187,  138,  139,  190,
 /*   960 */   101,   89,  198,  199,   97,  106,  107,   97,   81,   82,
 /*   970 */   271,  152,  267,  154,  155,  156,  185,  118,   62,   63,
 /*   980 */    64,   65,  219,  219,   68,   69,   70,   71,   72,   73,
 /*   990 */    74,   75,   97,   77,   78,   79,   80,   81,   82,   83,
 /*  1000 */    84,   85,   86,   87,  158,  146,  119,  120,  106,  107,
 /*  1010 */   219,  101,  106,  107,  106,  251,  106,  107,  272,  273,
 /*  1020 */    62,   63,   64,   65,  118,  117,   68,   69,   70,   71,
 /*  1030 */    72,   73,   74,   75,   97,   77,   78,   79,   80,   81,
 /*  1040 */    82,   83,   84,   85,   86,   87,  144,   62,   63,   64,
 /*  1050 */    65,    4,  146,   68,   69,   70,   71,   72,   73,   74,
 /*  1060 */    75,  177,   77,   78,   79,   80,   81,   82,   83,   84,
 /*  1070 */    85,   86,   87,  163,  190,  159,  191,  192,  193,  195,
 /*  1080 */   196,   97,   97,   62,   63,   64,   65,   97,  104,   68,
 /*  1090 */    69,   70,   71,   72,   73,   74,   75,  104,   77,   78,
 /*  1100 */    79,   80,   81,   82,   83,   84,   85,   86,   87,  185,
 /*  1110 */   172,  173,   13,   62,   63,   64,   65,  159,   97,   68,
 /*  1120 */    69,   70,   71,   72,   73,   74,   75,  177,   77,   78,
 /*  1130 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   97,
 /*  1140 */   190,  185,  104,  219,  260,  261,  104,   97,   97,   62,
 /*  1150 */    63,   64,   65,  106,  107,   68,   69,   70,   71,   72,
 /*  1160 */    73,   74,   75,  116,   77,   78,   79,   80,   81,   82,
 /*  1170 */    83,   84,   85,   86,   87,  219,    4,  138,  139,   62,
 /*  1180 */    63,   64,   65,   25,   97,   68,   69,   70,   71,   72,
 /*  1190 */    73,   74,   75,  243,   77,   78,   79,   80,   81,   82,
 /*  1200 */    83,   84,   85,   86,   87,  185,   13,  185,  197,   96,
 /*  1210 */    13,   62,   63,   64,   65,   98,  205,   68,   69,   70,
 /*  1220 */    71,   72,   73,   74,   75,   97,   77,   78,   79,   80,
 /*  1230 */    81,   82,   83,   84,   85,   86,   87,   55,   89,  219,
 /*  1240 */     4,  219,   62,   63,   64,   65,   30,   89,   68,   69,
 /*  1250 */    70,   71,   72,   73,   74,   75,  191,   77,   78,   79,
 /*  1260 */    80,   81,   82,   83,   84,   85,   86,   87,  144,   89,
 /*  1270 */    99,   89,   99,  101,   62,   63,   64,   65,  106,  107,
 /*  1280 */    68,   69,   70,   71,   72,   73,   74,   75,    4,   77,
 /*  1290 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*  1300 */   235,   62,   63,   64,   65,   83,  104,   68,   69,   70,
 /*  1310 */    71,   72,   73,   74,   75,  177,   77,   78,   79,   80,
 /*  1320 */    81,   82,   83,   84,   85,   86,   87,    4,  190,   96,
 /*  1330 */    96,  191,  191,  201,  162,  201,  198,  199,   15,   63,
 /*  1340 */    64,   65,  106,  107,   68,   69,   70,   71,   72,   73,
 /*  1350 */    74,   75,    4,   77,   78,   79,   80,   81,   82,   83,
 /*  1360 */    84,   85,   86,   87,  177,   42,   97,   17,  177,   97,
 /*  1370 */   232,  233,  177,  186,  187,  235,  235,  190,  177,    4,
 /*  1380 */   185,  190,   59,    4,  252,  190,  252,   64,  152,  251,
 /*  1390 */   106,  190,  135,  198,  199,  177,  209,   97,  211,  198,
 /*  1400 */   199,  117,  177,    4,   81,   82,   97,   38,  190,  177,
 /*  1410 */     4,   88,  191,    4,  219,  190,  198,  199,   97,   96,
 /*  1420 */    97,   15,  190,   96,  101,  104,  103,  232,  233,  106,
 /*  1430 */   107,    4,  177,  232,  111,    4,  177,  212,    4,   91,
 /*  1440 */     4,  118,  119,  120,  121,  190,  251,  177,   42,  190,
 /*  1450 */     6,  181,  251,    4,  106,  107,  235,  198,  199,   97,
 /*  1460 */   190,   97,    4,   38,   96,   59,  104,    4,  104,  251,
 /*  1470 */    64,  177,  254,  252,   97,  152,  101,  154,  155,  156,
 /*  1480 */   101,  106,  107,  258,  190,  106,  107,   81,   82,   96,
 /*  1490 */    96,  232,   38,    4,   88,  115,    4,   64,  243,  100,
 /*  1500 */   101,   96,   96,   97,   15,  106,  107,  101,  133,  103,
 /*  1510 */   251,  132,  106,  107,    4,  106,  107,  111,  129,    4,
 /*  1520 */   103,    4,   98,  177,  118,  119,  120,  121,  101,    4,
 /*  1530 */   123,   42,  101,  106,  107,  101,  190,  106,  107,   12,
 /*  1540 */   106,  107,  106,  107,  142,  118,    4,  128,   59,  118,
 /*  1550 */   101,   71,  118,   64,   71,  106,  107,  139,  152,  101,
 /*  1560 */   154,  155,  156,    4,  106,  107,  157,  118,    4,  106,
 /*  1570 */    81,   82,   22,  153,  177,    4,   89,   88,  177,   89,
 /*  1580 */   117,  177,  146,   47,   39,   96,   15,  190,  104,  243,
 /*  1590 */   101,  190,  103,  101,  190,  106,  107,    4,  106,  107,
 /*  1600 */   111,    4,  198,  199,  146,  177,   91,  118,  119,  120,
 /*  1610 */   121,  101,  177,   42,   39,   96,  106,  107,  190,  123,
 /*  1620 */   161,  106,  107,  106,  107,  190,  198,  199,  118,  177,
 /*  1630 */    59,  106,  107,  198,  199,   64,   95,  236,  237,   96,
 /*  1640 */    98,  152,  190,  154,  155,  156,   97,  158,  106,  132,
 /*  1650 */    91,  177,   81,   82,  143,  251,    7,  165,    4,   88,
 /*  1660 */    11,  103,  177,  177,  190,  106,  107,   96,   97,   15,
 /*  1670 */   106,  107,  101,  276,  103,  190,  190,  106,  107,  251,
 /*  1680 */   177,   32,  111,  141,  198,  199,  251,  162,   97,  118,
 /*  1690 */   119,  120,  121,  190,   93,  177,   42,    4,   95,  106,
 /*  1700 */   107,  198,  199,  106,  107,  141,  177,   37,  190,  177,
 /*  1710 */    36,  177,  189,   59,  252,  118,  198,  199,   64,  190,
 /*  1720 */   127,  177,  190,  152,  190,  154,  155,  156,    4,  238,
 /*  1730 */   198,  199,  198,  199,  190,   81,   82,  251,    4,  177,
 /*  1740 */     4,  212,   88,  204,  204,  177,  177,  275,  273,  177,
 /*  1750 */    96,   15,  190,  275,  251,  101,  212,  103,  190,  190,
 /*  1760 */   106,  107,  190,   90,  177,  111,  198,  199,  181,  251,
 /*  1770 */   198,  199,  118,  119,  120,  121,  177,  190,   42,    4,
 /*  1780 */   176,  176,  176,  251,  176,  251,   49,  258,  177,  190,
 /*  1790 */   177,  177,  181,  100,  177,   59,  178,  198,  199,  106,
 /*  1800 */   107,  190,  258,  190,  190,  178,  152,  190,  154,  155,
 /*  1810 */   156,  198,  199,  177,  180,  198,  199,   81,   82,  251,
 /*  1820 */   177,   60,  183,  251,   88,  104,  190,   56,  184,  138,
 /*  1830 */   106,  107,   96,  190,  198,  199,  177,  101,  276,  103,
 /*  1840 */   106,  107,  106,  107,    4,  177,  221,  111,  177,  190,
 /*  1850 */   251,  237,  177,  227,  118,  119,  120,  121,  190,    4,
 /*  1860 */   228,  190,  177,  151,  251,  190,  198,  199,  251,  229,
 /*  1870 */   148,  230,  147,  198,  199,  190,  152,  149,  231,  150,
 /*  1880 */   177,  106,  107,  198,  199,  252,  177,  251,  152,   64,
 /*  1890 */   154,  155,  156,  190,   87,  203,  177,   96,  164,  190,
 /*  1900 */   177,  198,  199,  177,  259,   87,  255,  198,  199,  190,
 /*  1910 */   177,  203,  158,  190,   99,  177,  190,  198,  199,  251,
 /*  1920 */   177,  198,  199,  190,  198,  199,  251,  177,  190,  241,
 /*  1930 */   241,  198,  199,  190,   99,  139,  251,    4,  163,  177,
 /*  1940 */   190,  198,  199,  177,  177,  177,  106,  107,  198,  199,
 /*  1950 */   177,    4,  190,  223,  251,  200,  190,  190,  190,  123,
 /*  1960 */   251,  106,  107,  190,  198,  199,  198,  199,  177,    4,
 /*  1970 */   251,  198,  199,  118,  251,  177,  200,  251,    4,  177,
 /*  1980 */   177,  190,  208,  181,  251,  177,  146,  177,  190,  198,
 /*  1990 */   199,  177,  190,  190,  251,    4,  198,  199,  190,    4,
 /*  2000 */   190,  251,   31,    4,  190,    4,  198,  199,  198,  199,
 /*  2010 */   177,  200,  198,  199,  177,  177,  177,  251,    4,  251,
 /*  2020 */     4,  177,  202,  190,  251,  177,  122,  190,  190,  190,
 /*  2030 */   177,  198,  199,  100,  190,  177,  198,  199,  190,  106,
 /*  2040 */   107,  200,  251,  190,    4,  177,  198,  199,  190,  251,
 /*  2050 */   203,  198,  199,  106,  107,   99,  198,  199,  190,  251,
 /*  2060 */   208,  251,  177,    4,  177,  251,  198,  199,    4,  177,
 /*  2070 */     4,  106,  107,    4,  177,  190,  200,  190,  200,  200,
 /*  2080 */   106,  107,  190,  118,  251,  198,  199,  190,  200,  251,
 /*  2090 */   198,  199,  118,  203,  180,  198,  199,  106,  107,  251,
 /*  2100 */   241,  106,  107,  177,  251,  106,  107,  106,  107,  251,
 /*  2110 */    99,  180,  165,  118,  177,  177,  190,  118,  181,  251,
 /*  2120 */   106,  107,  106,  107,  133,  241,  177,  190,  190,  177,
 /*  2130 */   181,   99,  118,  181,  118,  264,  177,   27,  251,  190,
 /*  2140 */   181,  177,  190,  251,  177,  181,  106,  107,  251,  190,
 /*  2150 */   177,  265,  158,  152,  190,  177,  177,  190,  118,  100,
 /*  2160 */    99,  177,  227,  190,  100,  106,  107,  177,  190,  190,
 /*  2170 */   106,  107,  106,  107,  190,  106,  107,  177,  215,  177,
 /*  2180 */   190,  177,  177,  177,   62,   99,   99,   96,  180,  250,
 /*  2190 */   190,  215,  190,   99,  190,  190,  190,  227,  241,  180,
 /*  2200 */    99,  241,  217,   60,   99,  217,   99,   99,   99,  217,
 /*  2210 */   217,   99,  268,  241,   18,   99,  268,   99,  152,   99,
 /*  2220 */   270,  152,  241,  241,   16,  201,  240,  224,  201,  261,
 /*  2230 */   261,  256,  206,  226,  191,  210,  202,  227,  242,  242,
 /*  2240 */   242,  224,  175,  191,  191,  191,  263,  216,  207,  262,
 /*  2250 */   222,  239,  207,  207,  274,  198,  198,   55,  211,  277,
 /*  2260 */   277,  277,  253,
};
#define YY_SHIFT_USE_DFLT (-81)
#define YY_SHIFT_COUNT (434)
#define YY_SHIFT_MIN   (-80)
#define YY_SHIFT_MAX   (2208)
static const short yy_shift_ofst[] = {
 /*     0 */  1158,   -4,  201, 1182,  819, 1571, 1571,  689,  361, 1489,
 /*    10 */  1654, 1654,  770,  364,  364,  157,   81,  179, 1406, 1323,
 /*    20 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*    30 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*    40 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654, 1654,
 /*    50 */  1654, 1654, 1654, 1654, 1654, 1654, 1654, 1736,  370,  798,
 /*    60 */   181,  370, 2001, 2001, 2001, 2001, 2001,  887,  887,  565,
 /*    70 */   277,    4, 1510, 1492, 1458, 1375, 1449, 1434, 1431, 1427,
 /*    80 */  1379,  448, 1399, 2066, 2066, 2069,  439, 2066, 2064, 2001,
 /*    90 */   565, 1039,  538,  538,  735,   84,   44,  171,  859,  775,
 /*   100 */   906,  773,  910,  636, 1172,    5,  450,    5,  443,  413,
 /*   110 */   185, 2059, 2040, 1775, 1947, 1840, 1991, 2016, 1933, 2014,
 /*   120 */  1525, 1999, 1724, 1995, 1974, 1965, 1734, 1517, 1693, 1855,
 /*   130 */  1047, 1593, 1597,  902,  140, 1542, 1542, 1436, 1564, 1542,
 /*   140 */  1236,  780, 1409,  349,  562,  216,  620, 1559, 1515, 1348,
 /*   150 */    90,  829,  829,  829,  872,  544, 2202, 2202, 2202, 2202,
 /*   160 */  2202,  -81,  -81,  459,  619,  619,  619,  619,  619,  619,
 /*   170 */   619,  619,  619,  645,  327,  683, 1180, 1149, 1117, 1087,
 /*   180 */  1051, 1021,  985,  958,  916,  767, 1239, 1212, 1276,  509,
 /*   190 */   509,  -60,  -38,  -38,  -38,  -38,  578,  -80,  314,   87,
 /*   200 */    87,   41,  155,   75,   58,   58,   58,   -6,  186,  862,
 /*   210 */   -47,  808, 1649, 1463, 1284,  206,  908,  424,  400,   25,
 /*   220 */   729,  729,  679, 1364,   -2,  855,  729,  442,  346,  855,
 /*   230 */   750,  750,  187,   -9,  169, 2208, 2120, 2118, 2116, 2196,
 /*   240 */  2196, 2112, 2109, 2143, 2108, 2143, 2107, 2143, 2105, 2143,
 /*   250 */  2101, 1761, 1712, 2094, 1761, 2122, 2091, 2087, 2086, 2122,
 /*   260 */  1712, 2061, 1994, 2110, 2032, 1761, 2011, 1761, 1956, 1801,
 /*   270 */  1836, 1836, 1836, 1836, 1971, 1801, 1836, 1904, 1836, 1971,
 /*   280 */  1836, 1836, 1796, 1835, 1815, 1754, 1801, 1818, 1801, 1825,
 /*   290 */  1807, 1729, 1725, 1728, 1722, 1712, 1691, 1771, 1721, 1761,
 /*   300 */  1737, 1737, 1673, 1673, 1673, 1673,  -81,  -81,  -81,  -81,
 /*   310 */   -81,  -81,  -81,  -81,  -81,  -81,  564,   79,  158,   45,
 /*   320 */   702,  243,  -49,  398, 1362, 1321, 1042,  984,  788,    2,
 /*   330 */   471,  -20,  758,  678,  344,  144,  -44, 1674, 1670, 1601,
 /*   340 */  1603, 1591, 1549, 1558, 1543, 1511, 1541, 1519, 1496, 1459,
 /*   350 */  1575, 1484, 1545, 1536, 1550, 1490, 1487, 1418, 1420, 1483,
 /*   360 */  1480, 1419, 1402, 1527, 1407, 1424, 1417, 1433, 1389, 1380,
 /*   370 */  1405, 1454, 1394, 1393, 1377, 1368, 1425, 1444, 1327, 1369,
 /*   380 */  1350, 1309, 1300, 1272, 1202, 1257, 1234, 1269, 1233, 1202,
 /*   390 */  1222, 1173, 1171, 1124, 1128, 1050, 1216, 1197, 1113,  993,
 /*   400 */  1193, 1038, 1099,  993,  990,  937,  846,  895,  870,  848,
 /*   410 */   867,  825,  757,  805,  675,  652,  571,  644,  625,  613,
 /*   420 */   571,  438,  474,  421,  399,  406,  355,  362,  231,  225,
 /*   430 */   166,  143,   63,  -37,  -61,
};
#define YY_REDUCE_USE_DFLT (-100)
#define YY_REDUCE_COUNT (315)
#define YY_REDUCE_MIN   (-99)
#define YY_REDUCE_MAX   (2067)
static const short yy_reduce_ofst[] = {
 /*     0 */   615, 1195,  699,  -99,  764, 1138,  189,  705, 1259, 1218,
 /*    10 */  1201,  261,  196,  884,  599, 1187, 1897, 1892, 1887, 1868,
 /*    20 */  1858, 1853, 1848, 1838, 1833, 1814, 1810, 1808, 1798, 1791,
 /*    30 */  1773, 1768, 1766, 1750, 1743, 1733, 1726, 1723, 1719, 1709,
 /*    40 */  1703, 1685, 1675, 1668, 1636, 1617, 1613, 1599, 1572, 1568,
 /*    50 */  1534, 1532, 1518, 1503, 1486, 1435, 1428, 1404,  490, 1401,
 /*    60 */   214,  769, 1544, 1529, 1225,  124,   67,  596,  175,  547,
 /*    70 */  1221, 1614, 1964, 1959, 1952, 1949, 1937, 1802, 1611, 1587,
 /*    80 */  1270, 1562,  203, 1346, 1255,  131,  347,  950, 1397,  195,
 /*    90 */   885,  265, 1134, 1132,  125,  377, 1011, 2006, 2005, 1979,
 /*   100 */  1671, 1671, 2004, 2002, 2000,  697, 1990,   11, 1671, 1984,
 /*   110 */  1979, 1978, 1671, 1671, 1671, 1671, 1671, 1671, 1671, 1973,
 /*   120 */  1671, 1671, 1967, 1671, 1671, 1938, 1671, 1671, 1671, 1926,
 /*   130 */  1885, 1844, 1839, 1837, 1803, 1141, 1140, 1767, 1762, 1065,
 /*   140 */  1738, 1671, 1659, 1643, 1569, 1485,  632, 1474, 1452, 1294,
 /*   150 */  1232, 1191,  666,  489,  938, 1022, 1020,  956,  924,  791,
 /*   160 */   763,  746,  205, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
 /*   170 */  1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
 /*   180 */  1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462,
 /*   190 */  1462, 1462, 1462, 1462, 1462, 1462, 1462, 1462, 2047, 2058,
 /*   200 */  2057, 1462, 1980, 1980, 2046, 2045, 2041, 2012, 2031, 2009,
 /*   210 */  2028, 1983, 1987, 2054, 2053, 2052, 2043, 2017, 2067, 2010,
 /*   220 */  1998, 1997, 2034, 2025, 2026, 2027, 1996, 1986, 1975, 2024,
 /*   230 */  1969, 1968, 1462, 2007, 2003, 1950, 1859, 1982, 1981, 1948,
 /*   240 */  1944, 1972, 1859, 1993, 1859, 1992, 1859, 1988, 1859, 1985,
 /*   250 */  1960, 2019, 1970, 1957, 2008, 1976, 1939, 1859, 1859, 1963,
 /*   260 */  1935, 1859, 1886, 1871, 1884, 1931, 1859, 1914, 1859, 1890,
 /*   270 */  1888, 1879, 1878, 1876, 1852, 1847, 1841, 1820, 1811, 1774,
 /*   280 */  1776, 1755, 1730, 1689, 1688, 1651, 1708, 1645, 1692, 1633,
 /*   290 */  1462, 1647, 1641, 1640, 1632, 1626, 1625, 1644, 1639, 1634,
 /*   300 */  1627, 1618, 1608, 1606, 1605, 1604, 1478, 1472, 1475, 1540,
 /*   310 */  1539, 1491, 1462, 1462, 1462, 1523,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   729, 1037, 1142, 1142, 1026, 1026, 1026, 1142, 1026, 1026,
 /*    10 */  1026, 1026,  900, 1148, 1148, 1148, 1026, 1026, 1026, 1026,
 /*    20 */  1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026,
 /*    30 */  1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026,
 /*    40 */  1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026, 1026,
 /*    50 */  1026, 1026, 1026, 1026, 1026, 1026, 1026, 1015, 1148,  894,
 /*    60 */  1148, 1148, 1148, 1148, 1148, 1148, 1148, 1148, 1148,  774,
 /*    70 */   890,  900, 1148, 1148, 1148, 1148, 1148,  962,  949,  940,
 /*    80 */  1148, 1148, 1148,  972,  972,  955,  842,  972, 1148, 1148,
 /*    90 */  1148, 1148,  928,  928, 1027, 1148,  766, 1112, 1117, 1013,
 /*   100 */  1148, 1148, 1148, 1148, 1148, 1148, 1148, 1148,  901, 1148,
 /*   110 */  1013, 1148, 1148, 1148, 1148, 1148, 1148, 1148, 1148, 1148,
 /*   120 */  1148,  963,  956,  950,  941, 1148, 1148, 1148, 1148, 1148,
 /*   130 */  1148, 1148, 1148, 1148, 1148,  890,  890, 1148, 1148,  890,
 /*   140 */  1148, 1148, 1148, 1014, 1148, 1148,  763, 1148, 1148, 1148,
 /*   150 */   735, 1058, 1148, 1148,  729, 1142, 1142, 1142, 1142, 1142,
 /*   160 */  1142, 1135,  880,  935,  906,  945,  933,  937, 1038, 1031,
 /*   170 */  1032, 1030,  936, 1027, 1027, 1027, 1027, 1027, 1027, 1027,
 /*   180 */  1027, 1027, 1027, 1027, 1027, 1027, 1027, 1027,  988, 1000,
 /*   190 */   987,  995, 1004,  999,  996,  990,  989,  991, 1148, 1148,
 /*   200 */  1148,  992, 1148, 1148, 1148, 1148, 1148,  893, 1148, 1148,
 /*   210 */   864, 1148, 1086, 1148, 1148,  776, 1148,  878,  738,  944,
 /*   220 */   918,  918,  809,  833,  798,  928,  918,  908, 1033,  928,
 /*   230 */  1148, 1148,  993,  891,  878, 1126,  909,  909,  909, 1111,
 /*   240 */  1111,  909,  909,  855,  909,  855,  909,  855,  909,  855,
 /*   250 */   909,  760,  944,  909,  760,  846,  968,  909,  909,  846,
 /*   260 */   944,  909, 1093, 1091,  909,  760,  909,  760,  909, 1046,
 /*   270 */   844,  844,  844,  844,  825, 1046,  844,  809,  844,  825,
 /*   280 */   844,  844, 1148,  909,  909, 1148, 1046, 1052, 1046, 1027,
 /*   290 */   994,  934,  922,  932,  929,  944, 1148,  757,  828,  760,
 /*   300 */   746,  746,  734,  734,  734,  734, 1139, 1139, 1135,  811,
 /*   310 */   811,  896, 1003, 1002, 1001,  785, 1039, 1148, 1148, 1148,
 /*   320 */  1148, 1148, 1148, 1060, 1148, 1148, 1148, 1148, 1148, 1148,
 /*   330 */  1148, 1148, 1148, 1148, 1148, 1148, 1148, 1148,  730, 1148,
 /*   340 */  1148, 1148, 1148, 1148, 1129, 1148, 1148, 1148, 1148, 1148,
 /*   350 */  1148, 1090, 1089, 1148, 1148, 1148, 1148, 1148, 1148, 1148,
 /*   360 */  1148, 1148, 1148, 1078, 1148, 1148, 1148, 1148, 1148, 1148,
 /*   370 */  1148, 1148, 1148, 1148, 1148, 1148, 1148, 1148, 1148, 1148,
 /*   380 */  1148, 1148, 1148, 1148,  867,  869, 1148, 1148, 1148,  868,
 /*   390 */  1148, 1148, 1148, 1148, 1148, 1148, 1148, 1148, 1148,  930,
 /*   400 */  1148,  923, 1148, 1036, 1148, 1017, 1025, 1148, 1148, 1148,
 /*   410 */  1148, 1148, 1016, 1148, 1148, 1148, 1144, 1148, 1148, 1148,
 /*   420 */  1143, 1148, 1148, 1148, 1148, 1148, 1028,  980, 1148,  979,
 /*   430 */   978,  769, 1148,  744, 1148,  726,  731, 1128, 1125, 1127,
 /*   440 */  1122, 1123, 1121, 1124, 1120, 1118, 1119, 1116, 1114, 1113,
 /*   450 */  1115, 1110, 1106, 1066, 1064, 1062, 1071, 1070, 1069, 1068,
 /*   460 */  1067, 1063, 1061, 1065, 1059,  959,  947,  938,  862, 1105,
 /*   470 */  1103, 1104, 1057, 1055, 1056,  861,  860,  859,  854,  853,
 /*   480 */   852,  851, 1132, 1141, 1140, 1138, 1137, 1136, 1130, 1131,
 /*   490 */  1044, 1043, 1041, 1040, 1042,  762, 1082, 1085, 1084, 1083,
 /*   500 */  1088, 1087, 1080, 1092, 1097, 1096, 1101, 1100, 1099, 1098,
 /*   510 */  1095, 1077,  967,  966,  964,  969,  961,  960,  965,  952,
 /*   520 */   958,  957,  948,  951,  847,  943,  939,  942,  863, 1081,
 /*   530 */   858,  857,  856,  761,  756,  911,  755,  754,  765,  831,
 /*   540 */   832,  840,  843,  838,  841,  837,  836,  835,  839,  834,
 /*   550 */   830,  768,  767,  775,  824,  802,  800,  799,  803,  816,
 /*   560 */   815,  822,  821,  820,  819,  818,  814,  817,  813,  812,
 /*   570 */   804,  797,  796,  810,  795,  827,  826,  823,  794,  850,
 /*   580 */   849,  848,  845,  793,  792,  791,  790,  789,  788,  986,
 /*   590 */   985, 1006,  977,  865,  872,  871,  870,  874,  875,  885,
 /*   600 */   883,  882,  881,  917,  916,  915,  914,  913,  912,  905,
 /*   610 */   903,  899,  898,  904,  902,  920,  921,  919,  897,  889,
 /*   620 */   887,  888,  886,  974,  971,  973,  970,  907,  895,  892,
 /*   630 */   879,  925,  924, 1029, 1018, 1008, 1019,  910, 1007, 1005,
 /*   640 */  1028, 1025, 1020, 1102, 1024, 1012, 1011, 1010, 1147, 1145,
 /*   650 */  1146, 1049, 1051, 1054, 1053, 1050,  927,  926, 1048, 1047,
 /*   660 */  1009,  984,  781,  779,  780, 1074, 1073, 1076, 1075, 1072,
 /*   670 */   783,  782,  778,  777,  998,  997,  982, 1021, 1022,  981,
 /*   680 */  1023,  983,  770,  873,  866,  976,  975,  808,  807,  806,
 /*   690 */   805,  877,  876,  787,  801,  786,  784,  764,  759,  758,
 /*   700 */   753,  751,  748,  750,  747,  752,  749,  745,  743,  742,
 /*   710 */   741,  740,  739,  773,  772,  771,  769,  737,  736,  733,
 /*   720 */   732,  728,  727,  725,
};

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
**
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*      SPACE => nothing */
    0,  /*         ID => nothing */
    4,  /*      ABORT => ID */
    4,  /*     ACTION => ID */
    4,  /*      AFTER => ID */
    4,  /*    ANALYZE => ID */
    4,  /*        ASC => ID */
    4,  /*     ATTACH => ID */
    4,  /*     BEFORE => ID */
    4,  /*      BEGIN => ID */
    4,  /*         BY => ID */
    4,  /*    CASCADE => ID */
    4,  /*       CAST => ID */
    4,  /*   COLUMNKW => ID */
    4,  /*   CONFLICT => ID */
    4,  /*   DATABASE => ID */
    4,  /*   DEFERRED => ID */
    4,  /*       DESC => ID */
    4,  /*     DETACH => ID */
    4,  /*       EACH => ID */
    4,  /*        END => ID */
    4,  /*  EXCLUSIVE => ID */
    4,  /*    EXPLAIN => ID */
    4,  /*       FAIL => ID */
    4,  /*        FOR => ID */
    4,  /*     IGNORE => ID */
    4,  /*  IMMEDIATE => ID */
    4,  /*    INDEXED => ID */
    4,  /*  INITIALLY => ID */
    4,  /*    INSTEAD => ID */
    4,  /*    LIKE_KW => ID */
    4,  /*      MATCH => ID */
    4,  /*         NO => ID */
    4,  /*       PLAN => ID */
    4,  /*      QUERY => ID */
    4,  /*        KEY => ID */
    4,  /*         OF => ID */
    4,  /*     OFFSET => ID */
    4,  /*     PRAGMA => ID */
    4,  /*      RAISE => ID */
    4,  /*  RECURSIVE => ID */
    4,  /*    RELEASE => ID */
    4,  /*    REPLACE => ID */
    4,  /*   RESTRICT => ID */
    4,  /*        ROW => ID */
    4,  /*   ROLLBACK => ID */
    4,  /*  SAVEPOINT => ID */
    4,  /*       TEMP => ID */
    4,  /*    TRIGGER => ID */
    4,  /*     VACUUM => ID */
    4,  /*       VIEW => ID */
    4,  /*    VIRTUAL => ID */
    4,  /*       WITH => ID */
    4,  /*    WITHOUT => ID */
    4,  /*    REINDEX => ID */
    4,  /*     RENAME => ID */
    4,  /*   CTIME_KW => ID */
    4,  /*         IF => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
  QList<Token*>* tokens = nullptr;
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3_parseARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

void *sqlite3_parseCopyParserState(void* other)
{
  yyParser *pParser;
  yyParser *otherParser = (yyParser*)other;

  // Copy parser
  pParser = (yyParser*)malloc((size_t)sizeof(yyParser));
  memcpy(pParser, other, (size_t)sizeof(yyParser));

#if YYSTACKDEPTH<=0
  // Copy stack
  int stackSize = sizeof(yyStackEntry) * pParser->yystksz;
  pParser->yystack = malloc((size_t)stackSize);
  memcpy(pParser->yystack, ((yyParser*)other)->yystack, (size_t)stackSize);
#endif

  for (int i = 0; i <= pParser->yyidx; i++)
  {
      pParser->yystack[i].tokens = new QList<Token*>();
      *(pParser->yystack[i].tokens) = *(otherParser->yystack[i].tokens);
  }

  return pParser;
}

void sqlite3_parseAddToken(void* other, Token* token)
{
    yyParser *otherParser = (yyParser*)other;
    if (otherParser->yyidx < 0)
        return; // Nothing on stack yet. Might happen when parsing just whitespaces, nothing else.

    otherParser->yystack[otherParser->yyidx].tokens->append(token);
}

void sqlite3_parseRestoreParserState(void* saved, void* target)
{
  yyParser *pParser = (yyParser*)target;
  yyParser *savedParser = (yyParser*)saved;

  for (int i = 0; i <= pParser->yyidx; i++)
      delete pParser->yystack[i].tokens;

  memcpy(pParser, saved, (size_t)sizeof(yyParser));

  for (int i = 0; i <= savedParser->yyidx; i++)
  {
      pParser->yystack[i].tokens = new QList<Token*>();
      *(pParser->yystack[i].tokens) = *(savedParser->yystack[i].tokens);
  }

#if YYSTACKDEPTH<=0
  // Copy stack
  int stackSize = sizeof(yyStackEntry) * pParser->yystksz;
  pParser->yystack = relloc(pParser->yystack, (size_t)stackSize);
  memcpy(pParser->yystack, ((yyParser*)saved)->yystack, (size_t)stackSize);
#endif
}

void sqlite3_parseFreeSavedState(void* other)
{
    yyParser *pParser = (yyParser*)other;
    for (int i = 0; i <= pParser->yyidx; i++)
        delete pParser->yystack[i].tokens;

#if YYSTACKDEPTH<=0
    free(pParser->yystack);
#endif
    free(other);
}

#ifndef NDEBUG
/*
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3_parseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = {
  "$",             "ILLEGAL",       "COMMENT",       "SPACE",       
  "ID",            "ABORT",         "ACTION",        "AFTER",       
  "ANALYZE",       "ASC",           "ATTACH",        "BEFORE",      
  "BEGIN",         "BY",            "CASCADE",       "CAST",        
  "COLUMNKW",      "CONFLICT",      "DATABASE",      "DEFERRED",    
  "DESC",          "DETACH",        "EACH",          "END",         
  "EXCLUSIVE",     "EXPLAIN",       "FAIL",          "FOR",         
  "IGNORE",        "IMMEDIATE",     "INDEXED",       "INITIALLY",   
  "INSTEAD",       "LIKE_KW",       "MATCH",         "NO",          
  "PLAN",          "QUERY",         "KEY",           "OF",          
  "OFFSET",        "PRAGMA",        "RAISE",         "RECURSIVE",   
  "RELEASE",       "REPLACE",       "RESTRICT",      "ROW",         
  "ROLLBACK",      "SAVEPOINT",     "TEMP",          "TRIGGER",     
  "VACUUM",        "VIEW",          "VIRTUAL",       "WITH",        
  "WITHOUT",       "REINDEX",       "RENAME",        "CTIME_KW",    
  "IF",            "ANY",           "OR",            "AND",         
  "NOT",           "IS",            "BETWEEN",       "IN",          
  "ISNULL",        "NOTNULL",       "NE",            "EQ",          
  "GT",            "LE",            "LT",            "GE",          
  "ESCAPE",        "BITAND",        "BITOR",         "LSHIFT",      
  "RSHIFT",        "PLUS",          "MINUS",         "STAR",        
  "SLASH",         "REM",           "CONCAT",        "COLLATE",     
  "BITNOT",        "SEMI",          "TRANSACTION",   "ID_TRANS",    
  "COMMIT",        "TO",            "CREATE",        "TABLE",       
  "LP",            "RP",            "AS",            "DOT",         
  "ID_TAB_NEW",    "ID_DB",         "CTX_ROWID_KW",  "EXISTS",      
  "COMMA",         "ID_COL_NEW",    "STRING",        "JOIN_KW",     
  "ID_COL_TYPE",   "CONSTRAINT",    "DEFAULT",       "NULL",        
  "PRIMARY",       "UNIQUE",        "CHECK",         "REFERENCES",  
  "ID_CONSTR",     "ID_COLLATE",    "ID_TAB",        "INTEGER",     
  "FLOAT",         "BLOB",          "AUTOINCR",      "ON",          
  "INSERT",        "DELETE",        "UPDATE",        "ID_FK_MATCH", 
  "SET",           "DEFERRABLE",    "FOREIGN",       "DROP",        
  "ID_VIEW_NEW",   "ID_VIEW",       "UNION",         "ALL",         
  "EXCEPT",        "INTERSECT",     "SELECT",        "VALUES",      
  "DISTINCT",      "ID_ALIAS",      "FROM",          "USING",       
  "JOIN",          "ID_JOIN_OPTS",  "ID_IDX",        "ORDER",       
  "GROUP",         "HAVING",        "LIMIT",         "WHERE",       
  "ID_COL",        "INTO",          "VARIABLE",      "CASE",        
  "ID_FN",         "ID_ERR_MSG",    "WHEN",          "THEN",        
  "ELSE",          "INDEX",         "ID_IDX_NEW",    "ID_PRAGMA",   
  "ID_TRIG_NEW",   "ID_TRIG",       "ALTER",         "ADD",         
  "error",         "cmd",           "input",         "cmdlist",     
  "ecmd",          "explain",       "cmdx",          "transtype",   
  "trans_opt",     "nm",            "savepoint_opt",  "temp",        
  "ifnotexists",   "fullname",      "columnlist",    "conslist_opt",
  "table_options",  "select",        "column",        "columnid",    
  "type",          "carglist",      "id",            "ids",         
  "typetoken",     "typename",      "signed",        "plus_num",    
  "minus_num",     "ccons",         "term",          "expr",        
  "onconf",        "sortorder",     "autoinc",       "idxlist_opt", 
  "refargs",       "defer_subclause",  "refarg",        "refact",      
  "init_deferred_pred_opt",  "conslist",      "tconscomma",    "tcons",       
  "idxlist",       "defer_subclause_opt",  "resolvetype",   "orconf",      
  "raisetype",     "ifexists",      "select_stmt",   "with",        
  "selectnowith",  "oneselect",     "multiselect_op",  "values",      
  "distinct",      "selcollist",    "from",          "where_opt",   
  "groupby_opt",   "having_opt",    "orderby_opt",   "limit_opt",   
  "nexprlist",     "exprlist",      "sclp",          "as",          
  "joinsrc",       "singlesrc",     "seltablist",    "joinop",      
  "joinconstr_opt",  "dbnm",          "indexed_opt",   "inscollist",  
  "sortlist",      "delete_stmt",   "update_stmt",   "setlist",     
  "insert_stmt",   "insert_cmd",    "inscollist_opt",  "exprx",       
  "not_opt",       "likeop",        "case_operand",  "case_exprlist",
  "case_else",     "uniqueflag",    "idxlist_single",  "collate",     
  "nmnum",         "number",        "trigger_time",  "trigger_event",
  "foreach_clause",  "when_clause",   "trigger_cmd_list",  "trigger_cmd", 
  "database_kw_opt",  "key_opt",       "kwcolumn_opt",  "create_vtab", 
  "vtabarglist",   "vtabarg",       "vtabargtoken",  "anylist",     
  "wqlist",      
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "ecmd ::= SEMI",
 /*   4 */ "ecmd ::= explain cmdx SEMI",
 /*   5 */ "explain ::=",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   8 */ "cmdx ::= cmd",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "trans_opt ::= TRANSACTION ID_TRANS",
 /*  14 */ "transtype ::=",
 /*  15 */ "transtype ::= DEFERRED",
 /*  16 */ "transtype ::= IMMEDIATE",
 /*  17 */ "transtype ::= EXCLUSIVE",
 /*  18 */ "cmd ::= COMMIT trans_opt",
 /*  19 */ "cmd ::= END trans_opt",
 /*  20 */ "cmd ::= ROLLBACK trans_opt",
 /*  21 */ "savepoint_opt ::= SAVEPOINT",
 /*  22 */ "savepoint_opt ::=",
 /*  23 */ "cmd ::= SAVEPOINT nm",
 /*  24 */ "cmd ::= RELEASE savepoint_opt nm",
 /*  25 */ "cmd ::= ROLLBACK trans_opt TO savepoint_opt nm",
 /*  26 */ "cmd ::= SAVEPOINT ID_TRANS",
 /*  27 */ "cmd ::= RELEASE savepoint_opt ID_TRANS",
 /*  28 */ "cmd ::= ROLLBACK trans_opt TO savepoint_opt ID_TRANS",
 /*  29 */ "cmd ::= CREATE temp TABLE ifnotexists fullname LP columnlist conslist_opt RP table_options",
 /*  30 */ "cmd ::= CREATE temp TABLE ifnotexists fullname AS select",
 /*  31 */ "cmd ::= CREATE temp TABLE ifnotexists nm DOT ID_TAB_NEW",
 /*  32 */ "cmd ::= CREATE temp TABLE ifnotexists ID_DB|ID_TAB_NEW",
 /*  33 */ "table_options ::=",
 /*  34 */ "table_options ::= WITHOUT nm",
 /*  35 */ "table_options ::= WITHOUT CTX_ROWID_KW",
 /*  36 */ "ifnotexists ::=",
 /*  37 */ "ifnotexists ::= IF NOT EXISTS",
 /*  38 */ "temp ::= TEMP",
 /*  39 */ "temp ::=",
 /*  40 */ "columnlist ::= columnlist COMMA column",
 /*  41 */ "columnlist ::= column",
 /*  42 */ "column ::= columnid type carglist",
 /*  43 */ "columnid ::= nm",
 /*  44 */ "columnid ::= ID_COL_NEW",
 /*  45 */ "id ::= ID",
 /*  46 */ "ids ::= ID|STRING",
 /*  47 */ "nm ::= id",
 /*  48 */ "nm ::= STRING",
 /*  49 */ "nm ::= JOIN_KW",
 /*  50 */ "type ::=",
 /*  51 */ "type ::= typetoken",
 /*  52 */ "typetoken ::= typename",
 /*  53 */ "typetoken ::= typename LP signed RP",
 /*  54 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  55 */ "typename ::= ids",
 /*  56 */ "typename ::= typename ids",
 /*  57 */ "typename ::= ID_COL_TYPE",
 /*  58 */ "signed ::= plus_num",
 /*  59 */ "signed ::= minus_num",
 /*  60 */ "carglist ::= carglist ccons",
 /*  61 */ "carglist ::=",
 /*  62 */ "ccons ::= CONSTRAINT nm",
 /*  63 */ "ccons ::= DEFAULT term",
 /*  64 */ "ccons ::= DEFAULT LP expr RP",
 /*  65 */ "ccons ::= DEFAULT PLUS term",
 /*  66 */ "ccons ::= DEFAULT MINUS term",
 /*  67 */ "ccons ::= DEFAULT id",
 /*  68 */ "ccons ::= DEFAULT CTIME_KW",
 /*  69 */ "ccons ::= NULL onconf",
 /*  70 */ "ccons ::= NOT NULL onconf",
 /*  71 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  72 */ "ccons ::= UNIQUE onconf",
 /*  73 */ "ccons ::= CHECK LP expr RP",
 /*  74 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  75 */ "ccons ::= defer_subclause",
 /*  76 */ "ccons ::= COLLATE ids",
 /*  77 */ "ccons ::= CONSTRAINT ID_CONSTR",
 /*  78 */ "ccons ::= COLLATE ID_COLLATE",
 /*  79 */ "ccons ::= REFERENCES ID_TAB",
 /*  80 */ "ccons ::= CHECK LP RP",
 /*  81 */ "term ::= NULL",
 /*  82 */ "term ::= INTEGER",
 /*  83 */ "term ::= FLOAT",
 /*  84 */ "term ::= STRING|BLOB",
 /*  85 */ "autoinc ::=",
 /*  86 */ "autoinc ::= AUTOINCR",
 /*  87 */ "refargs ::=",
 /*  88 */ "refargs ::= refargs refarg",
 /*  89 */ "refarg ::= MATCH nm",
 /*  90 */ "refarg ::= ON INSERT refact",
 /*  91 */ "refarg ::= ON DELETE refact",
 /*  92 */ "refarg ::= ON UPDATE refact",
 /*  93 */ "refarg ::= MATCH ID_FK_MATCH",
 /*  94 */ "refact ::= SET NULL",
 /*  95 */ "refact ::= SET DEFAULT",
 /*  96 */ "refact ::= CASCADE",
 /*  97 */ "refact ::= RESTRICT",
 /*  98 */ "refact ::= NO ACTION",
 /*  99 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /* 100 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /* 101 */ "init_deferred_pred_opt ::=",
 /* 102 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /* 103 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /* 104 */ "conslist_opt ::=",
 /* 105 */ "conslist_opt ::= COMMA conslist",
 /* 106 */ "conslist ::= conslist tconscomma tcons",
 /* 107 */ "conslist ::= tcons",
 /* 108 */ "tconscomma ::= COMMA",
 /* 109 */ "tconscomma ::=",
 /* 110 */ "tcons ::= CONSTRAINT nm",
 /* 111 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /* 112 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /* 113 */ "tcons ::= CHECK LP expr RP onconf",
 /* 114 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /* 115 */ "tcons ::= CONSTRAINT ID_CONSTR",
 /* 116 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES ID_TAB",
 /* 117 */ "tcons ::= CHECK LP RP onconf",
 /* 118 */ "defer_subclause_opt ::=",
 /* 119 */ "defer_subclause_opt ::= defer_subclause",
 /* 120 */ "onconf ::=",
 /* 121 */ "onconf ::= ON CONFLICT resolvetype",
 /* 122 */ "orconf ::=",
 /* 123 */ "orconf ::= OR resolvetype",
 /* 124 */ "resolvetype ::= raisetype",
 /* 125 */ "resolvetype ::= IGNORE",
 /* 126 */ "resolvetype ::= REPLACE",
 /* 127 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 128 */ "cmd ::= DROP TABLE ifexists nm DOT ID_TAB",
 /* 129 */ "cmd ::= DROP TABLE ifexists ID_DB|ID_TAB",
 /* 130 */ "ifexists ::= IF EXISTS",
 /* 131 */ "ifexists ::=",
 /* 132 */ "cmd ::= CREATE temp VIEW ifnotexists fullname AS select",
 /* 133 */ "cmd ::= CREATE temp VIEW ifnotexists nm DOT ID_VIEW_NEW",
 /* 134 */ "cmd ::= CREATE temp VIEW ifnotexists ID_DB|ID_VIEW_NEW",
 /* 135 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 136 */ "cmd ::= DROP VIEW ifexists nm DOT ID_VIEW",
 /* 137 */ "cmd ::= DROP VIEW ifexists ID_DB|ID_VIEW",
 /* 138 */ "cmd ::= select_stmt",
 /* 139 */ "select_stmt ::= select",
 /* 140 */ "select ::= with selectnowith",
 /* 141 */ "selectnowith ::= oneselect",
 /* 142 */ "selectnowith ::= selectnowith multiselect_op oneselect",
 /* 143 */ "selectnowith ::= values",
 /* 144 */ "selectnowith ::= selectnowith COMMA values",
 /* 145 */ "multiselect_op ::= UNION",
 /* 146 */ "multiselect_op ::= UNION ALL",
 /* 147 */ "multiselect_op ::= EXCEPT",
 /* 148 */ "multiselect_op ::= INTERSECT",
 /* 149 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 150 */ "values ::= VALUES LP nexprlist RP",
 /* 151 */ "values ::= values COMMA LP exprlist RP",
 /* 152 */ "distinct ::= DISTINCT",
 /* 153 */ "distinct ::= ALL",
 /* 154 */ "distinct ::=",
 /* 155 */ "sclp ::= selcollist COMMA",
 /* 156 */ "sclp ::=",
 /* 157 */ "selcollist ::= sclp expr as",
 /* 158 */ "selcollist ::= sclp STAR",
 /* 159 */ "selcollist ::= sclp nm DOT STAR",
 /* 160 */ "selcollist ::= sclp",
 /* 161 */ "selcollist ::= sclp ID_TAB DOT STAR",
 /* 162 */ "as ::= AS nm",
 /* 163 */ "as ::= ids",
 /* 164 */ "as ::= AS ID_ALIAS",
 /* 165 */ "as ::= ID_ALIAS",
 /* 166 */ "as ::=",
 /* 167 */ "from ::=",
 /* 168 */ "from ::= FROM joinsrc",
 /* 169 */ "joinsrc ::= singlesrc seltablist",
 /* 170 */ "joinsrc ::=",
 /* 171 */ "seltablist ::= seltablist joinop singlesrc joinconstr_opt",
 /* 172 */ "seltablist ::=",
 /* 173 */ "singlesrc ::= nm dbnm as indexed_opt",
 /* 174 */ "singlesrc ::= LP select RP as",
 /* 175 */ "singlesrc ::= LP joinsrc RP as",
 /* 176 */ "singlesrc ::=",
 /* 177 */ "singlesrc ::= nm DOT",
 /* 178 */ "singlesrc ::= nm DOT ID_TAB",
 /* 179 */ "singlesrc ::= ID_DB|ID_TAB",
 /* 180 */ "singlesrc ::= nm DOT ID_VIEW",
 /* 181 */ "singlesrc ::= ID_DB|ID_VIEW",
 /* 182 */ "joinconstr_opt ::= ON expr",
 /* 183 */ "joinconstr_opt ::= USING LP inscollist RP",
 /* 184 */ "joinconstr_opt ::=",
 /* 185 */ "dbnm ::=",
 /* 186 */ "dbnm ::= DOT nm",
 /* 187 */ "fullname ::= nm dbnm",
 /* 188 */ "joinop ::= COMMA",
 /* 189 */ "joinop ::= JOIN",
 /* 190 */ "joinop ::= JOIN_KW JOIN",
 /* 191 */ "joinop ::= JOIN_KW nm JOIN",
 /* 192 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 193 */ "joinop ::= ID_JOIN_OPTS",
 /* 194 */ "indexed_opt ::=",
 /* 195 */ "indexed_opt ::= INDEXED BY nm",
 /* 196 */ "indexed_opt ::= NOT INDEXED",
 /* 197 */ "indexed_opt ::= INDEXED BY ID_IDX",
 /* 198 */ "orderby_opt ::=",
 /* 199 */ "orderby_opt ::= ORDER BY sortlist",
 /* 200 */ "sortlist ::= sortlist COMMA expr sortorder",
 /* 201 */ "sortlist ::= expr sortorder",
 /* 202 */ "sortorder ::= ASC",
 /* 203 */ "sortorder ::= DESC",
 /* 204 */ "sortorder ::=",
 /* 205 */ "groupby_opt ::=",
 /* 206 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 207 */ "groupby_opt ::= GROUP BY",
 /* 208 */ "having_opt ::=",
 /* 209 */ "having_opt ::= HAVING expr",
 /* 210 */ "limit_opt ::=",
 /* 211 */ "limit_opt ::= LIMIT expr",
 /* 212 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 213 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 214 */ "cmd ::= delete_stmt",
 /* 215 */ "delete_stmt ::= with DELETE FROM fullname indexed_opt where_opt",
 /* 216 */ "delete_stmt ::= with DELETE FROM",
 /* 217 */ "delete_stmt ::= with DELETE FROM nm DOT",
 /* 218 */ "delete_stmt ::= with DELETE FROM nm DOT ID_TAB",
 /* 219 */ "delete_stmt ::= with DELETE FROM ID_DB|ID_TAB",
 /* 220 */ "where_opt ::=",
 /* 221 */ "where_opt ::= WHERE expr",
 /* 222 */ "where_opt ::= WHERE",
 /* 223 */ "cmd ::= update_stmt",
 /* 224 */ "update_stmt ::= with UPDATE orconf fullname indexed_opt SET setlist where_opt",
 /* 225 */ "update_stmt ::= with UPDATE orconf",
 /* 226 */ "update_stmt ::= with UPDATE orconf nm DOT",
 /* 227 */ "update_stmt ::= with UPDATE orconf nm DOT ID_TAB",
 /* 228 */ "update_stmt ::= with UPDATE orconf ID_DB|ID_TAB",
 /* 229 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 230 */ "setlist ::= nm EQ expr",
 /* 231 */ "setlist ::=",
 /* 232 */ "setlist ::= setlist COMMA",
 /* 233 */ "setlist ::= setlist COMMA ID_COL",
 /* 234 */ "setlist ::= ID_COL",
 /* 235 */ "cmd ::= insert_stmt",
 /* 236 */ "insert_stmt ::= with insert_cmd INTO fullname inscollist_opt select",
 /* 237 */ "insert_stmt ::= with insert_cmd INTO fullname inscollist_opt DEFAULT VALUES",
 /* 238 */ "insert_stmt ::= with insert_cmd INTO",
 /* 239 */ "insert_stmt ::= with insert_cmd INTO nm DOT",
 /* 240 */ "insert_stmt ::= with insert_cmd INTO ID_DB|ID_TAB",
 /* 241 */ "insert_stmt ::= with insert_cmd INTO nm DOT ID_TAB",
 /* 242 */ "insert_cmd ::= INSERT orconf",
 /* 243 */ "insert_cmd ::= REPLACE",
 /* 244 */ "inscollist_opt ::=",
 /* 245 */ "inscollist_opt ::= LP inscollist RP",
 /* 246 */ "inscollist ::= inscollist COMMA nm",
 /* 247 */ "inscollist ::= nm",
 /* 248 */ "inscollist ::=",
 /* 249 */ "inscollist ::= inscollist COMMA ID_COL",
 /* 250 */ "inscollist ::= ID_COL",
 /* 251 */ "exprx ::= term",
 /* 252 */ "exprx ::= CTIME_KW",
 /* 253 */ "exprx ::= LP expr RP",
 /* 254 */ "exprx ::= id",
 /* 255 */ "exprx ::= JOIN_KW",
 /* 256 */ "exprx ::= nm DOT nm",
 /* 257 */ "exprx ::= nm DOT nm DOT nm",
 /* 258 */ "exprx ::= VARIABLE",
 /* 259 */ "exprx ::= expr COLLATE ids",
 /* 260 */ "exprx ::= CAST LP expr AS typetoken RP",
 /* 261 */ "exprx ::= ID LP distinct exprlist RP",
 /* 262 */ "exprx ::= ID LP STAR RP",
 /* 263 */ "exprx ::= expr AND expr",
 /* 264 */ "exprx ::= expr OR expr",
 /* 265 */ "exprx ::= expr LT|GT|GE|LE expr",
 /* 266 */ "exprx ::= expr EQ|NE expr",
 /* 267 */ "exprx ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 268 */ "exprx ::= expr PLUS|MINUS expr",
 /* 269 */ "exprx ::= expr STAR|SLASH|REM expr",
 /* 270 */ "exprx ::= expr CONCAT expr",
 /* 271 */ "exprx ::= expr not_opt likeop expr",
 /* 272 */ "exprx ::= expr not_opt likeop expr ESCAPE expr",
 /* 273 */ "exprx ::= expr ISNULL|NOTNULL",
 /* 274 */ "exprx ::= expr NOT NULL",
 /* 275 */ "exprx ::= expr IS not_opt expr",
 /* 276 */ "exprx ::= NOT expr",
 /* 277 */ "exprx ::= BITNOT expr",
 /* 278 */ "exprx ::= MINUS expr",
 /* 279 */ "exprx ::= PLUS expr",
 /* 280 */ "exprx ::= expr not_opt BETWEEN expr AND expr",
 /* 281 */ "exprx ::= expr not_opt IN LP exprlist RP",
 /* 282 */ "exprx ::= LP select RP",
 /* 283 */ "exprx ::= expr not_opt IN LP select RP",
 /* 284 */ "exprx ::= expr not_opt IN nm dbnm",
 /* 285 */ "exprx ::= EXISTS LP select RP",
 /* 286 */ "exprx ::= CASE case_operand case_exprlist case_else END",
 /* 287 */ "exprx ::= RAISE LP IGNORE RP",
 /* 288 */ "exprx ::= RAISE LP raisetype COMMA nm RP",
 /* 289 */ "exprx ::= nm DOT",
 /* 290 */ "exprx ::= nm DOT nm DOT",
 /* 291 */ "exprx ::= expr not_opt BETWEEN expr AND",
 /* 292 */ "exprx ::= CASE case_operand case_exprlist case_else",
 /* 293 */ "exprx ::= expr not_opt IN LP exprlist",
 /* 294 */ "exprx ::= expr not_opt IN ID_DB",
 /* 295 */ "exprx ::= expr not_opt IN nm DOT ID_TAB",
 /* 296 */ "exprx ::= ID_DB|ID_TAB|ID_COL|ID_FN",
 /* 297 */ "exprx ::= nm DOT ID_TAB|ID_COL",
 /* 298 */ "exprx ::= nm DOT nm DOT ID_COL",
 /* 299 */ "exprx ::= expr COLLATE ID_COLLATE",
 /* 300 */ "exprx ::= RAISE LP raisetype COMMA ID_ERR_MSG RP",
 /* 301 */ "expr ::= exprx",
 /* 302 */ "expr ::=",
 /* 303 */ "not_opt ::=",
 /* 304 */ "not_opt ::= NOT",
 /* 305 */ "likeop ::= LIKE_KW|MATCH",
 /* 306 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 307 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 308 */ "case_else ::= ELSE expr",
 /* 309 */ "case_else ::=",
 /* 310 */ "case_operand ::= exprx",
 /* 311 */ "case_operand ::=",
 /* 312 */ "exprlist ::= nexprlist",
 /* 313 */ "exprlist ::=",
 /* 314 */ "nexprlist ::= nexprlist COMMA expr",
 /* 315 */ "nexprlist ::= exprx",
 /* 316 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP where_opt",
 /* 317 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON ID_TAB",
 /* 318 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm DOT ID_IDX_NEW",
 /* 319 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists ID_DB|ID_IDX_NEW",
 /* 320 */ "uniqueflag ::= UNIQUE",
 /* 321 */ "uniqueflag ::=",
 /* 322 */ "idxlist_opt ::=",
 /* 323 */ "idxlist_opt ::= LP idxlist RP",
 /* 324 */ "idxlist ::= idxlist COMMA idxlist_single",
 /* 325 */ "idxlist ::= idxlist_single",
 /* 326 */ "idxlist_single ::= nm collate sortorder",
 /* 327 */ "idxlist_single ::= ID_COL",
 /* 328 */ "collate ::=",
 /* 329 */ "collate ::= COLLATE ids",
 /* 330 */ "collate ::= COLLATE ID_COLLATE",
 /* 331 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 332 */ "cmd ::= DROP INDEX ifexists nm DOT ID_IDX",
 /* 333 */ "cmd ::= DROP INDEX ifexists ID_DB|ID_IDX",
 /* 334 */ "cmd ::= VACUUM",
 /* 335 */ "cmd ::= VACUUM nm",
 /* 336 */ "cmd ::= PRAGMA nm dbnm",
 /* 337 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 338 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 339 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 340 */ "cmd ::= PRAGMA nm dbnm LP minus_num RP",
 /* 341 */ "cmd ::= PRAGMA nm DOT ID_PRAGMA",
 /* 342 */ "cmd ::= PRAGMA ID_DB|ID_PRAGMA",
 /* 343 */ "nmnum ::= plus_num",
 /* 344 */ "nmnum ::= nm",
 /* 345 */ "nmnum ::= ON",
 /* 346 */ "nmnum ::= DELETE",
 /* 347 */ "nmnum ::= DEFAULT",
 /* 348 */ "plus_num ::= PLUS number",
 /* 349 */ "plus_num ::= number",
 /* 350 */ "minus_num ::= MINUS number",
 /* 351 */ "number ::= INTEGER",
 /* 352 */ "number ::= FLOAT",
 /* 353 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list END",
 /* 354 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause",
 /* 355 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list",
 /* 356 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON ID_TAB",
 /* 357 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm DOT ID_TRIG_NEW",
 /* 358 */ "cmd ::= CREATE temp TRIGGER ifnotexists ID_DB|ID_TRIG_NEW",
 /* 359 */ "trigger_time ::= BEFORE",
 /* 360 */ "trigger_time ::= AFTER",
 /* 361 */ "trigger_time ::= INSTEAD OF",
 /* 362 */ "trigger_time ::=",
 /* 363 */ "trigger_event ::= DELETE",
 /* 364 */ "trigger_event ::= INSERT",
 /* 365 */ "trigger_event ::= UPDATE",
 /* 366 */ "trigger_event ::= UPDATE OF inscollist",
 /* 367 */ "foreach_clause ::=",
 /* 368 */ "foreach_clause ::= FOR EACH ROW",
 /* 369 */ "when_clause ::=",
 /* 370 */ "when_clause ::= WHEN expr",
 /* 371 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 372 */ "trigger_cmd_list ::= trigger_cmd SEMI",
 /* 373 */ "trigger_cmd_list ::= SEMI",
 /* 374 */ "trigger_cmd ::= update_stmt",
 /* 375 */ "trigger_cmd ::= insert_stmt",
 /* 376 */ "trigger_cmd ::= delete_stmt",
 /* 377 */ "trigger_cmd ::= select_stmt",
 /* 378 */ "raisetype ::= ROLLBACK|ABORT|FAIL",
 /* 379 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 380 */ "cmd ::= DROP TRIGGER ifexists nm DOT ID_TRIG",
 /* 381 */ "cmd ::= DROP TRIGGER ifexists ID_DB|ID_TRIG",
 /* 382 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 383 */ "cmd ::= DETACH database_kw_opt expr",
 /* 384 */ "key_opt ::=",
 /* 385 */ "key_opt ::= KEY expr",
 /* 386 */ "database_kw_opt ::= DATABASE",
 /* 387 */ "database_kw_opt ::=",
 /* 388 */ "cmd ::= REINDEX",
 /* 389 */ "cmd ::= REINDEX nm dbnm",
 /* 390 */ "cmd ::= REINDEX ID_COLLATE",
 /* 391 */ "cmd ::= REINDEX nm DOT ID_TAB|ID_IDX",
 /* 392 */ "cmd ::= REINDEX ID_DB|ID_IDX|ID_TAB",
 /* 393 */ "cmd ::= ANALYZE",
 /* 394 */ "cmd ::= ANALYZE nm dbnm",
 /* 395 */ "cmd ::= ANALYZE nm DOT ID_TAB|ID_IDX",
 /* 396 */ "cmd ::= ANALYZE ID_DB|ID_IDX|ID_TAB",
 /* 397 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 398 */ "cmd ::= ALTER TABLE fullname ADD kwcolumn_opt column",
 /* 399 */ "cmd ::= ALTER TABLE fullname RENAME TO ID_TAB_NEW",
 /* 400 */ "cmd ::= ALTER TABLE nm DOT ID_TAB",
 /* 401 */ "cmd ::= ALTER TABLE ID_DB|ID_TAB",
 /* 402 */ "kwcolumn_opt ::=",
 /* 403 */ "kwcolumn_opt ::= COLUMNKW",
 /* 404 */ "cmd ::= create_vtab",
 /* 405 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm",
 /* 406 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm LP vtabarglist RP",
 /* 407 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm DOT ID_TAB_NEW",
 /* 408 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists ID_DB|ID_TAB_NEW",
 /* 409 */ "vtabarglist ::= vtabarg",
 /* 410 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 411 */ "vtabarg ::=",
 /* 412 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 413 */ "vtabargtoken ::= ANY",
 /* 414 */ "vtabargtoken ::= LP anylist RP",
 /* 415 */ "anylist ::=",
 /* 416 */ "anylist ::= anylist LP anylist RP",
 /* 417 */ "anylist ::= anylist ANY",
 /* 418 */ "with ::=",
 /* 419 */ "with ::= WITH wqlist",
 /* 420 */ "with ::= WITH RECURSIVE wqlist",
 /* 421 */ "wqlist ::= nm idxlist_opt AS LP select RP",
 /* 422 */ "wqlist ::= wqlist COMMA nm idxlist_opt AS LP select RP",
 /* 423 */ "wqlist ::= ID_TAB_NEW",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/*
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3_parse and sqlite3_parseFree.
*/
void *sqlite3_parseAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  sqlite3_parseARG_FETCH;
  if (parserContext->executeRules)
  {
      switch( yymajor ){
        /* Here is inserted the actions which take place when a
        ** terminal or non-terminal is destroyed.  This can happen
        ** when the symbol is popped from the stack during a
        ** reduce or during error processing or when a parser is
        ** being destroyed before it is finished parsing.
        **
        ** Note: during a reduce, the only symbols destroyed are those
        ** which appear on the RHS of the rule, but which are not used
        ** inside the C code.
        */
    case 169: /* cmd */
    case 172: /* ecmd */
    case 174: /* cmdx */
    case 218: /* select_stmt */
    case 245: /* delete_stmt */
    case 246: /* update_stmt */
    case 248: /* insert_stmt */
    case 267: /* trigger_cmd */
    case 271: /* create_vtab */
{
delete (yypminor->yy399);
}
      break;
    case 173: /* explain */
{
delete (yypminor->yy225);
}
      break;
    case 175: /* transtype */
    case 176: /* trans_opt */
{
delete (yypminor->yy300);
}
      break;
    case 177: /* nm */
    case 184: /* table_options */
    case 187: /* columnid */
    case 190: /* id */
    case 191: /* ids */
    case 193: /* typename */
    case 241: /* dbnm */
    case 259: /* collate */
    case 273: /* vtabarg */
    case 274: /* vtabargtoken */
    case 275: /* anylist */
{
delete (yypminor->yy211);
}
      break;
    case 178: /* savepoint_opt */
    case 180: /* ifnotexists */
    case 202: /* autoinc */
    case 210: /* tconscomma */
    case 217: /* ifexists */
    case 252: /* not_opt */
    case 257: /* uniqueflag */
    case 268: /* database_kw_opt */
    case 270: /* kwcolumn_opt */
{
delete (yypminor->yy237);
}
      break;
    case 179: /* temp */
    case 224: /* distinct */
{
delete (yypminor->yy376);
}
      break;
    case 181: /* fullname */
{
delete (yypminor->yy66);
}
      break;
    case 182: /* columnlist */
{
delete (yypminor->yy118);
}
      break;
    case 183: /* conslist_opt */
    case 209: /* conslist */
{
delete (yypminor->yy87);
}
      break;
    case 185: /* select */
    case 220: /* selectnowith */
{
delete (yypminor->yy123);
}
      break;
    case 186: /* column */
{
delete (yypminor->yy425);
}
      break;
    case 188: /* type */
    case 192: /* typetoken */
{
delete (yypminor->yy299);
}
      break;
    case 189: /* carglist */
{
delete (yypminor->yy449);
}
      break;
    case 194: /* signed */
    case 195: /* plus_num */
    case 196: /* minus_num */
    case 198: /* term */
    case 260: /* nmnum */
    case 261: /* number */
{
delete (yypminor->yy21);
}
      break;
    case 197: /* ccons */
{
delete (yypminor->yy4);
}
      break;
    case 199: /* expr */
    case 227: /* where_opt */
    case 229: /* having_opt */
    case 251: /* exprx */
    case 254: /* case_operand */
    case 256: /* case_else */
{
delete (yypminor->yy490);
}
      break;
    case 200: /* onconf */
    case 214: /* resolvetype */
    case 215: /* orconf */
{
delete (yypminor->yy30);
}
      break;
    case 201: /* sortorder */
{
delete (yypminor->yy226);
}
      break;
    case 203: /* idxlist_opt */
    case 212: /* idxlist */
{
delete (yypminor->yy139);
}
      break;
    case 204: /* refargs */
{
delete (yypminor->yy108);
}
      break;
    case 205: /* defer_subclause */
    case 213: /* defer_subclause_opt */
{
delete (yypminor->yy131);
}
      break;
    case 206: /* refarg */
{
delete (yypminor->yy271);
}
      break;
    case 207: /* refact */
{
delete (yypminor->yy312);
}
      break;
    case 208: /* init_deferred_pred_opt */
{
delete (yypminor->yy498);
}
      break;
    case 211: /* tcons */
{
delete (yypminor->yy8);
}
      break;
    case 219: /* with */
    case 276: /* wqlist */
{
delete (yypminor->yy367);
}
      break;
    case 221: /* oneselect */
{
delete (yypminor->yy468);
}
      break;
    case 222: /* multiselect_op */
{
delete (yypminor->yy168);
}
      break;
    case 223: /* values */
{
delete (yypminor->yy416);
}
      break;
    case 225: /* selcollist */
    case 234: /* sclp */
{
delete (yypminor->yy263);
}
      break;
    case 226: /* from */
    case 236: /* joinsrc */
{
delete (yypminor->yy373);
}
      break;
    case 228: /* groupby_opt */
    case 232: /* nexprlist */
    case 233: /* exprlist */
    case 255: /* case_exprlist */
{
delete (yypminor->yy13);
}
      break;
    case 230: /* orderby_opt */
    case 244: /* sortlist */
{
delete (yypminor->yy495);
}
      break;
    case 231: /* limit_opt */
{
delete (yypminor->yy128);
}
      break;
    case 235: /* as */
{
delete (yypminor->yy28);
}
      break;
    case 237: /* singlesrc */
{
delete (yypminor->yy173);
}
      break;
    case 238: /* seltablist */
{
delete (yypminor->yy359);
}
      break;
    case 239: /* joinop */
{
delete (yypminor->yy473);
}
      break;
    case 240: /* joinconstr_opt */
{
delete (yypminor->yy117);
}
      break;
    case 242: /* indexed_opt */
{
delete (yypminor->yy472);
}
      break;
    case 243: /* inscollist */
    case 250: /* inscollist_opt */
    case 272: /* vtabarglist */
{
delete (yypminor->yy445);
}
      break;
    case 247: /* setlist */
{
delete (yypminor->yy381);
}
      break;
    case 249: /* insert_cmd */
{
delete (yypminor->yy250);
}
      break;
    case 253: /* likeop */
{
delete (yypminor->yy374);
}
      break;
    case 258: /* idxlist_single */
{
delete (yypminor->yy90);
}
      break;
    case 262: /* trigger_time */
{
delete (yypminor->yy152);
}
      break;
    case 263: /* trigger_event */
{
delete (yypminor->yy309);
}
      break;
    case 264: /* foreach_clause */
{
delete (yypminor->yy409);
}
      break;
    case 265: /* when_clause */
    case 269: /* key_opt */
{
if ((yypminor->yy490)) delete (yypminor->yy490);
}
      break;
    case 266: /* trigger_cmd_list */
{
delete (yypminor->yy214);
}
      break;
        default:  break;   /* If no destructor action specified: do nothing */
      }
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  /* There is no mechanism by which the parser stack can be popped below
  ** empty in SQLite.  */
  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  delete yytos->tokens;
  yytos->tokens = nullptr;
  pParser->yyidx--;
  return yymajor;
}

/*
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3_parseAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3_parseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  /* In SQLite, we never try to destroy a parser that was not successfully
  ** created in the first place. */
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int sqlite3_parseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
  GET_CONTEXT;

  if( stateno>YY_SHIFT_COUNT
   || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0
             && parserContext->doFallbacks ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if(
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          yy_lookahead[j]==YYWILDCARD
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   sqlite3_parseARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */

    UNUSED_PARAMETER(yypMinor);
    parserContext->error(QObject::tr("Parser stack overflow"));
   sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor = *yypMinor;
  yytos->tokens = new QList<Token*>();
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 170, 1 },
  { 171, 2 },
  { 171, 1 },
  { 172, 1 },
  { 172, 3 },
  { 173, 0 },
  { 173, 1 },
  { 173, 3 },
  { 174, 1 },
  { 169, 3 },
  { 176, 0 },
  { 176, 1 },
  { 176, 2 },
  { 176, 2 },
  { 175, 0 },
  { 175, 1 },
  { 175, 1 },
  { 175, 1 },
  { 169, 2 },
  { 169, 2 },
  { 169, 2 },
  { 178, 1 },
  { 178, 0 },
  { 169, 2 },
  { 169, 3 },
  { 169, 5 },
  { 169, 2 },
  { 169, 3 },
  { 169, 5 },
  { 169, 10 },
  { 169, 7 },
  { 169, 7 },
  { 169, 5 },
  { 184, 0 },
  { 184, 2 },
  { 184, 2 },
  { 180, 0 },
  { 180, 3 },
  { 179, 1 },
  { 179, 0 },
  { 182, 3 },
  { 182, 1 },
  { 186, 3 },
  { 187, 1 },
  { 187, 1 },
  { 190, 1 },
  { 191, 1 },
  { 177, 1 },
  { 177, 1 },
  { 177, 1 },
  { 188, 0 },
  { 188, 1 },
  { 192, 1 },
  { 192, 4 },
  { 192, 6 },
  { 193, 1 },
  { 193, 2 },
  { 193, 1 },
  { 194, 1 },
  { 194, 1 },
  { 189, 2 },
  { 189, 0 },
  { 197, 2 },
  { 197, 2 },
  { 197, 4 },
  { 197, 3 },
  { 197, 3 },
  { 197, 2 },
  { 197, 2 },
  { 197, 2 },
  { 197, 3 },
  { 197, 5 },
  { 197, 2 },
  { 197, 4 },
  { 197, 4 },
  { 197, 1 },
  { 197, 2 },
  { 197, 2 },
  { 197, 2 },
  { 197, 2 },
  { 197, 3 },
  { 198, 1 },
  { 198, 1 },
  { 198, 1 },
  { 198, 1 },
  { 202, 0 },
  { 202, 1 },
  { 204, 0 },
  { 204, 2 },
  { 206, 2 },
  { 206, 3 },
  { 206, 3 },
  { 206, 3 },
  { 206, 2 },
  { 207, 2 },
  { 207, 2 },
  { 207, 1 },
  { 207, 1 },
  { 207, 2 },
  { 205, 3 },
  { 205, 2 },
  { 208, 0 },
  { 208, 2 },
  { 208, 2 },
  { 183, 0 },
  { 183, 2 },
  { 209, 3 },
  { 209, 1 },
  { 210, 1 },
  { 210, 0 },
  { 211, 2 },
  { 211, 7 },
  { 211, 5 },
  { 211, 5 },
  { 211, 10 },
  { 211, 2 },
  { 211, 7 },
  { 211, 4 },
  { 213, 0 },
  { 213, 1 },
  { 200, 0 },
  { 200, 3 },
  { 215, 0 },
  { 215, 2 },
  { 214, 1 },
  { 214, 1 },
  { 214, 1 },
  { 169, 4 },
  { 169, 6 },
  { 169, 4 },
  { 217, 2 },
  { 217, 0 },
  { 169, 7 },
  { 169, 7 },
  { 169, 5 },
  { 169, 4 },
  { 169, 6 },
  { 169, 4 },
  { 169, 1 },
  { 218, 1 },
  { 185, 2 },
  { 220, 1 },
  { 220, 3 },
  { 220, 1 },
  { 220, 3 },
  { 222, 1 },
  { 222, 2 },
  { 222, 1 },
  { 222, 1 },
  { 221, 9 },
  { 223, 4 },
  { 223, 5 },
  { 224, 1 },
  { 224, 1 },
  { 224, 0 },
  { 234, 2 },
  { 234, 0 },
  { 225, 3 },
  { 225, 2 },
  { 225, 4 },
  { 225, 1 },
  { 225, 4 },
  { 235, 2 },
  { 235, 1 },
  { 235, 2 },
  { 235, 1 },
  { 235, 0 },
  { 226, 0 },
  { 226, 2 },
  { 236, 2 },
  { 236, 0 },
  { 238, 4 },
  { 238, 0 },
  { 237, 4 },
  { 237, 4 },
  { 237, 4 },
  { 237, 0 },
  { 237, 2 },
  { 237, 3 },
  { 237, 1 },
  { 237, 3 },
  { 237, 1 },
  { 240, 2 },
  { 240, 4 },
  { 240, 0 },
  { 241, 0 },
  { 241, 2 },
  { 181, 2 },
  { 239, 1 },
  { 239, 1 },
  { 239, 2 },
  { 239, 3 },
  { 239, 4 },
  { 239, 1 },
  { 242, 0 },
  { 242, 3 },
  { 242, 2 },
  { 242, 3 },
  { 230, 0 },
  { 230, 3 },
  { 244, 4 },
  { 244, 2 },
  { 201, 1 },
  { 201, 1 },
  { 201, 0 },
  { 228, 0 },
  { 228, 3 },
  { 228, 2 },
  { 229, 0 },
  { 229, 2 },
  { 231, 0 },
  { 231, 2 },
  { 231, 4 },
  { 231, 4 },
  { 169, 1 },
  { 245, 6 },
  { 245, 3 },
  { 245, 5 },
  { 245, 6 },
  { 245, 4 },
  { 227, 0 },
  { 227, 2 },
  { 227, 1 },
  { 169, 1 },
  { 246, 8 },
  { 246, 3 },
  { 246, 5 },
  { 246, 6 },
  { 246, 4 },
  { 247, 5 },
  { 247, 3 },
  { 247, 0 },
  { 247, 2 },
  { 247, 3 },
  { 247, 1 },
  { 169, 1 },
  { 248, 6 },
  { 248, 7 },
  { 248, 3 },
  { 248, 5 },
  { 248, 4 },
  { 248, 6 },
  { 249, 2 },
  { 249, 1 },
  { 250, 0 },
  { 250, 3 },
  { 243, 3 },
  { 243, 1 },
  { 243, 0 },
  { 243, 3 },
  { 243, 1 },
  { 251, 1 },
  { 251, 1 },
  { 251, 3 },
  { 251, 1 },
  { 251, 1 },
  { 251, 3 },
  { 251, 5 },
  { 251, 1 },
  { 251, 3 },
  { 251, 6 },
  { 251, 5 },
  { 251, 4 },
  { 251, 3 },
  { 251, 3 },
  { 251, 3 },
  { 251, 3 },
  { 251, 3 },
  { 251, 3 },
  { 251, 3 },
  { 251, 3 },
  { 251, 4 },
  { 251, 6 },
  { 251, 2 },
  { 251, 3 },
  { 251, 4 },
  { 251, 2 },
  { 251, 2 },
  { 251, 2 },
  { 251, 2 },
  { 251, 6 },
  { 251, 6 },
  { 251, 3 },
  { 251, 6 },
  { 251, 5 },
  { 251, 4 },
  { 251, 5 },
  { 251, 4 },
  { 251, 6 },
  { 251, 2 },
  { 251, 4 },
  { 251, 5 },
  { 251, 4 },
  { 251, 5 },
  { 251, 4 },
  { 251, 6 },
  { 251, 1 },
  { 251, 3 },
  { 251, 5 },
  { 251, 3 },
  { 251, 6 },
  { 199, 1 },
  { 199, 0 },
  { 252, 0 },
  { 252, 1 },
  { 253, 1 },
  { 255, 5 },
  { 255, 4 },
  { 256, 2 },
  { 256, 0 },
  { 254, 1 },
  { 254, 0 },
  { 233, 1 },
  { 233, 0 },
  { 232, 3 },
  { 232, 1 },
  { 169, 12 },
  { 169, 8 },
  { 169, 7 },
  { 169, 5 },
  { 257, 1 },
  { 257, 0 },
  { 203, 0 },
  { 203, 3 },
  { 212, 3 },
  { 212, 1 },
  { 258, 3 },
  { 258, 1 },
  { 259, 0 },
  { 259, 2 },
  { 259, 2 },
  { 169, 4 },
  { 169, 6 },
  { 169, 4 },
  { 169, 1 },
  { 169, 2 },
  { 169, 3 },
  { 169, 5 },
  { 169, 6 },
  { 169, 5 },
  { 169, 6 },
  { 169, 4 },
  { 169, 2 },
  { 260, 1 },
  { 260, 1 },
  { 260, 1 },
  { 260, 1 },
  { 260, 1 },
  { 195, 2 },
  { 195, 1 },
  { 196, 2 },
  { 261, 1 },
  { 261, 1 },
  { 169, 15 },
  { 169, 12 },
  { 169, 14 },
  { 169, 10 },
  { 169, 7 },
  { 169, 5 },
  { 262, 1 },
  { 262, 1 },
  { 262, 2 },
  { 262, 0 },
  { 263, 1 },
  { 263, 1 },
  { 263, 1 },
  { 263, 3 },
  { 264, 0 },
  { 264, 3 },
  { 265, 0 },
  { 265, 2 },
  { 266, 3 },
  { 266, 2 },
  { 266, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 267, 1 },
  { 216, 1 },
  { 169, 4 },
  { 169, 6 },
  { 169, 4 },
  { 169, 6 },
  { 169, 3 },
  { 269, 0 },
  { 269, 2 },
  { 268, 1 },
  { 268, 0 },
  { 169, 1 },
  { 169, 3 },
  { 169, 2 },
  { 169, 4 },
  { 169, 2 },
  { 169, 1 },
  { 169, 3 },
  { 169, 4 },
  { 169, 2 },
  { 169, 6 },
  { 169, 6 },
  { 169, 6 },
  { 169, 5 },
  { 169, 3 },
  { 270, 0 },
  { 270, 1 },
  { 169, 1 },
  { 271, 8 },
  { 271, 11 },
  { 271, 7 },
  { 271, 5 },
  { 272, 1 },
  { 272, 3 },
  { 273, 0 },
  { 273, 2 },
  { 274, 1 },
  { 274, 3 },
  { 275, 0 },
  { 275, 4 },
  { 275, 2 },
  { 219, 0 },
  { 219, 2 },
  { 219, 3 },
  { 276, 6 },
  { 276, 8 },
  { 276, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3_parseARG_FETCH;
  SqliteStatement* objectForTokens = 0;
  QStringList noTokenInheritanceFields;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  if (parserContext->executeRules)
  {
      switch( yyruleno ){
      /* Beginning here are the reduction cases.  A typical example
      ** follows:
      **   case 0:
      **  #line <lineno> <grammarfile>
      **     { ... }           // User supplied code
      **  #line <lineno> <thisfile>
      **     break;
      */
      case 1: /* cmdlist ::= cmdlist ecmd */
{parserContext->addQuery(yymsp[0].minor.yy399); DONT_INHERIT_TOKENS("cmdlist");}
        break;
      case 2: /* cmdlist ::= ecmd */
{parserContext->addQuery(yymsp[0].minor.yy399);}
        break;
      case 3: /* ecmd ::= SEMI */
{yygotominor.yy399 = new SqliteEmptyQuery();}
        break;
      case 4: /* ecmd ::= explain cmdx SEMI */
{
                                                yygotominor.yy399 = yymsp[-1].minor.yy399;
                                                yygotominor.yy399->explain = yymsp[-2].minor.yy225->explain;
                                                yygotominor.yy399->queryPlan = yymsp[-2].minor.yy225->queryPlan;
                                                delete yymsp[-2].minor.yy225;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 5: /* explain ::= */
{yygotominor.yy225 = new ParserStubExplain(false, false);}
        break;
      case 6: /* explain ::= EXPLAIN */
{yygotominor.yy225 = new ParserStubExplain(true, false);}
        break;
      case 7: /* explain ::= EXPLAIN QUERY PLAN */
{yygotominor.yy225 = new ParserStubExplain(true, true);}
        break;
      case 8: /* cmdx ::= cmd */
      case 374: /* trigger_cmd ::= update_stmt */ yytestcase(yyruleno==374);
      case 375: /* trigger_cmd ::= insert_stmt */ yytestcase(yyruleno==375);
      case 376: /* trigger_cmd ::= delete_stmt */ yytestcase(yyruleno==376);
      case 377: /* trigger_cmd ::= select_stmt */ yytestcase(yyruleno==377);
      case 404: /* cmd ::= create_vtab */ yytestcase(yyruleno==404);
{yygotominor.yy399 = yymsp[0].minor.yy399;}
        break;
      case 9: /* cmd ::= BEGIN transtype trans_opt */
{
                                                yygotominor.yy399 = new SqliteBeginTrans(
                                                        yymsp[-1].minor.yy300->type,
                                                        yymsp[0].minor.yy300->transactionKw,
                                                        yymsp[0].minor.yy300->name
                                                    );
                                                delete yymsp[0].minor.yy300;
                                                delete yymsp[-1].minor.yy300;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 10: /* trans_opt ::= */
      case 14: /* transtype ::= */ yytestcase(yyruleno==14);
{yygotominor.yy300 = new ParserStubTransDetails();}
        break;
      case 11: /* trans_opt ::= TRANSACTION */
{
                                                yygotominor.yy300 = new ParserStubTransDetails();
                                                yygotominor.yy300->transactionKw = true;
                                            }
        break;
      case 12: /* trans_opt ::= TRANSACTION nm */
      case 13: /* trans_opt ::= TRANSACTION ID_TRANS */ yytestcase(yyruleno==13);
{
                                                yygotominor.yy300 = new ParserStubTransDetails();
                                                yygotominor.yy300->transactionKw = true;
                                                yygotominor.yy300->name = *(yymsp[0].minor.yy211);
                                                delete yymsp[0].minor.yy211;
                                            }
        break;
      case 15: /* transtype ::= DEFERRED */
{
                                                yygotominor.yy300 = new ParserStubTransDetails();
                                                yygotominor.yy300->type = SqliteBeginTrans::Type::DEFERRED;
                                            }
        break;
      case 16: /* transtype ::= IMMEDIATE */
{
                                                yygotominor.yy300 = new ParserStubTransDetails();
                                                yygotominor.yy300->type = SqliteBeginTrans::Type::IMMEDIATE;
                                            }
        break;
      case 17: /* transtype ::= EXCLUSIVE */
{
                                                yygotominor.yy300 = new ParserStubTransDetails();
                                                yygotominor.yy300->type = SqliteBeginTrans::Type::EXCLUSIVE;
                                            }
        break;
      case 18: /* cmd ::= COMMIT trans_opt */
{
                                                yygotominor.yy399 = new SqliteCommitTrans(
                                                        yymsp[0].minor.yy300->transactionKw,
                                                        yymsp[0].minor.yy300->name,
                                                        false
                                                    );
                                                delete yymsp[0].minor.yy300;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 19: /* cmd ::= END trans_opt */
{
                                                yygotominor.yy399 = new SqliteCommitTrans(
                                                        yymsp[0].minor.yy300->transactionKw,
                                                        yymsp[0].minor.yy300->name,
                                                        true
                                                    );
                                                delete yymsp[0].minor.yy300;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 20: /* cmd ::= ROLLBACK trans_opt */
{
                                                yygotominor.yy399 = new SqliteRollback(
                                                        yymsp[0].minor.yy300->transactionKw,
                                                        yymsp[0].minor.yy300->name
                                                    );
                                                delete yymsp[0].minor.yy300;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 21: /* savepoint_opt ::= SAVEPOINT */
      case 37: /* ifnotexists ::= IF NOT EXISTS */ yytestcase(yyruleno==37);
      case 86: /* autoinc ::= AUTOINCR */ yytestcase(yyruleno==86);
      case 108: /* tconscomma ::= COMMA */ yytestcase(yyruleno==108);
      case 130: /* ifexists ::= IF EXISTS */ yytestcase(yyruleno==130);
      case 304: /* not_opt ::= NOT */ yytestcase(yyruleno==304);
      case 320: /* uniqueflag ::= UNIQUE */ yytestcase(yyruleno==320);
      case 386: /* database_kw_opt ::= DATABASE */ yytestcase(yyruleno==386);
      case 402: /* kwcolumn_opt ::= */ yytestcase(yyruleno==402);
{yygotominor.yy237 = new bool(true);}
        break;
      case 22: /* savepoint_opt ::= */
      case 36: /* ifnotexists ::= */ yytestcase(yyruleno==36);
      case 85: /* autoinc ::= */ yytestcase(yyruleno==85);
      case 109: /* tconscomma ::= */ yytestcase(yyruleno==109);
      case 131: /* ifexists ::= */ yytestcase(yyruleno==131);
      case 303: /* not_opt ::= */ yytestcase(yyruleno==303);
      case 321: /* uniqueflag ::= */ yytestcase(yyruleno==321);
      case 387: /* database_kw_opt ::= */ yytestcase(yyruleno==387);
      case 403: /* kwcolumn_opt ::= COLUMNKW */ yytestcase(yyruleno==403);
{yygotominor.yy237 = new bool(false);}
        break;
      case 23: /* cmd ::= SAVEPOINT nm */
{
                                                yygotominor.yy399 = new SqliteSavepoint(*(yymsp[0].minor.yy211));
                                                delete yymsp[0].minor.yy211;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 24: /* cmd ::= RELEASE savepoint_opt nm */
{
                                                yygotominor.yy399 = new SqliteRelease(*(yymsp[-1].minor.yy237), *(yymsp[0].minor.yy211));
                                                delete yymsp[0].minor.yy211;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 25: /* cmd ::= ROLLBACK trans_opt TO savepoint_opt nm */
      case 26: /* cmd ::= SAVEPOINT ID_TRANS */ yytestcase(yyruleno==26);
{
                                                yygotominor.yy399 = new SqliteRollback(
                                                        yymsp[-3].minor.yy300->transactionKw,
                                                        *(yymsp[-1].minor.yy237),
                                                        *(yymsp[0].minor.yy211)
                                                    );
                                                delete yymsp[-1].minor.yy237;
                                                delete yymsp[-3].minor.yy300;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 27: /* cmd ::= RELEASE savepoint_opt ID_TRANS */
      case 28: /* cmd ::= ROLLBACK trans_opt TO savepoint_opt ID_TRANS */ yytestcase(yyruleno==28);
{  yy_destructor(yypParser,178,&yymsp[-1].minor);
}
        break;
      case 29: /* cmd ::= CREATE temp TABLE ifnotexists fullname LP columnlist conslist_opt RP table_options */
{
                                                yygotominor.yy399 = new SqliteCreateTable(
                                                        *(yymsp[-6].minor.yy237),
                                                        *(yymsp[-8].minor.yy376),
                                                        yymsp[-5].minor.yy66->name1,
                                                        yymsp[-5].minor.yy66->name2,
                                                        *(yymsp[-3].minor.yy118),
                                                        *(yymsp[-2].minor.yy87),
                                                        *(yymsp[0].minor.yy211)
                                                    );
                                                delete yymsp[-6].minor.yy237;
                                                delete yymsp[-8].minor.yy376;
                                                delete yymsp[-3].minor.yy118;
                                                delete yymsp[-2].minor.yy87;
                                                delete yymsp[-5].minor.yy66;
                                                delete yymsp[0].minor.yy211;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 30: /* cmd ::= CREATE temp TABLE ifnotexists fullname AS select */
{
                                                yygotominor.yy399 = new SqliteCreateTable(
                                                        *(yymsp[-3].minor.yy237),
                                                        *(yymsp[-5].minor.yy376),
                                                        yymsp[-2].minor.yy66->name1,
                                                        yymsp[-2].minor.yy66->name2,
                                                        yymsp[0].minor.yy123
                                                    );
                                                delete yymsp[-3].minor.yy237;
                                                delete yymsp[-5].minor.yy376;
                                                delete yymsp[-2].minor.yy66;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 31: /* cmd ::= CREATE temp TABLE ifnotexists nm DOT ID_TAB_NEW */
      case 133: /* cmd ::= CREATE temp VIEW ifnotexists nm DOT ID_VIEW_NEW */ yytestcase(yyruleno==133);
      case 357: /* cmd ::= CREATE temp TRIGGER ifnotexists nm DOT ID_TRIG_NEW */ yytestcase(yyruleno==357);
{  yy_destructor(yypParser,179,&yymsp[-5].minor);
  yy_destructor(yypParser,177,&yymsp[-2].minor);
}
        break;
      case 32: /* cmd ::= CREATE temp TABLE ifnotexists ID_DB|ID_TAB_NEW */
      case 134: /* cmd ::= CREATE temp VIEW ifnotexists ID_DB|ID_VIEW_NEW */ yytestcase(yyruleno==134);
      case 358: /* cmd ::= CREATE temp TRIGGER ifnotexists ID_DB|ID_TRIG_NEW */ yytestcase(yyruleno==358);
{  yy_destructor(yypParser,179,&yymsp[-3].minor);
}
        break;
      case 33: /* table_options ::= */
      case 185: /* dbnm ::= */ yytestcase(yyruleno==185);
      case 328: /* collate ::= */ yytestcase(yyruleno==328);
      case 411: /* vtabarg ::= */ yytestcase(yyruleno==411);
      case 415: /* anylist ::= */ yytestcase(yyruleno==415);
{yygotominor.yy211 = new QString();}
        break;
      case 34: /* table_options ::= WITHOUT nm */
      case 35: /* table_options ::= WITHOUT CTX_ROWID_KW */ yytestcase(yyruleno==35);
{
                                                if (yymsp[0].minor.yy211->toLower() != "rowid")
                                                    parserContext->errorAtToken(QString("Invalid table option: %1").arg(*(yymsp[0].minor.yy211)));

                                                yygotominor.yy211 = yymsp[0].minor.yy211;
                                            }
        break;
      case 38: /* temp ::= TEMP */
{yygotominor.yy376 = new int( (yymsp[0].minor.yy0->value.length() > 4) ? 2 : 1 );}
        break;
      case 39: /* temp ::= */
      case 154: /* distinct ::= */ yytestcase(yyruleno==154);
{yygotominor.yy376 = new int(0);}
        break;
      case 40: /* columnlist ::= columnlist COMMA column */
{
                                                yymsp[-2].minor.yy118->append(yymsp[0].minor.yy425);
                                                yygotominor.yy118 = yymsp[-2].minor.yy118;
                                                DONT_INHERIT_TOKENS("columnlist");
                                            }
        break;
      case 41: /* columnlist ::= column */
{
                                                yygotominor.yy118 = new ParserCreateTableColumnList();
                                                yygotominor.yy118->append(yymsp[0].minor.yy425);
                                            }
        break;
      case 42: /* column ::= columnid type carglist */
{
                                                yygotominor.yy425 = new SqliteCreateTable::Column(*(yymsp[-2].minor.yy211), yymsp[-1].minor.yy299, *(yymsp[0].minor.yy449));
                                                delete yymsp[-2].minor.yy211;
                                                delete yymsp[0].minor.yy449;
                                                objectForTokens = yygotominor.yy425;
                                            }
        break;
      case 43: /* columnid ::= nm */
      case 44: /* columnid ::= ID_COL_NEW */ yytestcase(yyruleno==44);
      case 47: /* nm ::= id */ yytestcase(yyruleno==47);
      case 55: /* typename ::= ids */ yytestcase(yyruleno==55);
      case 186: /* dbnm ::= DOT nm */ yytestcase(yyruleno==186);
      case 329: /* collate ::= COLLATE ids */ yytestcase(yyruleno==329);
      case 330: /* collate ::= COLLATE ID_COLLATE */ yytestcase(yyruleno==330);
{yygotominor.yy211 = yymsp[0].minor.yy211;}
        break;
      case 45: /* id ::= ID */
{
                                                yygotominor.yy211 = new QString(
                                                    stripObjName(
                                                        yymsp[0].minor.yy0->value,
                                                        parserContext->dialect
                                                    )
                                                );
                                            }
        break;
      case 46: /* ids ::= ID|STRING */
      case 49: /* nm ::= JOIN_KW */ yytestcase(yyruleno==49);
{yygotominor.yy211 = new QString(yymsp[0].minor.yy0->value);}
        break;
      case 48: /* nm ::= STRING */
{yygotominor.yy211 = new QString(stripString(yymsp[0].minor.yy0->value));}
        break;
      case 50: /* type ::= */
{yygotominor.yy299 = nullptr;}
        break;
      case 51: /* type ::= typetoken */
{yygotominor.yy299 = yymsp[0].minor.yy299;}
        break;
      case 52: /* typetoken ::= typename */
{
                                                yygotominor.yy299 = new SqliteColumnType(*(yymsp[0].minor.yy211));
                                                delete yymsp[0].minor.yy211;
                                                objectForTokens = yygotominor.yy299;
                                            }
        break;
      case 53: /* typetoken ::= typename LP signed RP */
{
                                                yygotominor.yy299 = new SqliteColumnType(*(yymsp[-3].minor.yy211), *(yymsp[-1].minor.yy21));
                                                delete yymsp[-3].minor.yy211;
                                                delete yymsp[-1].minor.yy21;
                                                objectForTokens = yygotominor.yy299;
                                            }
        break;
      case 54: /* typetoken ::= typename LP signed COMMA signed RP */
{
                                                yygotominor.yy299 = new SqliteColumnType(*(yymsp[-5].minor.yy211), *(yymsp[-3].minor.yy21), *(yymsp[-1].minor.yy21));
                                                delete yymsp[-5].minor.yy211;
                                                delete yymsp[-3].minor.yy21;
                                                delete yymsp[-1].minor.yy21;
                                                objectForTokens = yygotominor.yy299;
                                            }
        break;
      case 56: /* typename ::= typename ids */
      case 57: /* typename ::= ID_COL_TYPE */ yytestcase(yyruleno==57);
{
                                                yymsp[-1].minor.yy211->append(" " + *(yymsp[0].minor.yy211));
                                                delete yymsp[0].minor.yy211;
                                                yygotominor.yy211 = yymsp[-1].minor.yy211;
                                            }
        break;
      case 58: /* signed ::= plus_num */
      case 59: /* signed ::= minus_num */ yytestcase(yyruleno==59);
      case 343: /* nmnum ::= plus_num */ yytestcase(yyruleno==343);
      case 348: /* plus_num ::= PLUS number */ yytestcase(yyruleno==348);
      case 349: /* plus_num ::= number */ yytestcase(yyruleno==349);
{yygotominor.yy21 = yymsp[0].minor.yy21;}
        break;
      case 60: /* carglist ::= carglist ccons */
{
                                                yymsp[-1].minor.yy449->append(yymsp[0].minor.yy4);
                                                yygotominor.yy449 = yymsp[-1].minor.yy449;
                                                DONT_INHERIT_TOKENS("carglist");
                                            }
        break;
      case 61: /* carglist ::= */
{yygotominor.yy449 = new ParserCreateTableColumnConstraintList();}
        break;
      case 62: /* ccons ::= CONSTRAINT nm */
{
                                                yygotominor.yy4 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy4->initDefNameOnly(*(yymsp[0].minor.yy211));
                                                delete yymsp[0].minor.yy211;
                                                objectForTokens = yygotominor.yy4;
                                            }
        break;
      case 63: /* ccons ::= DEFAULT term */
{
                                                yygotominor.yy4 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy4->initDefTerm(*(yymsp[0].minor.yy21));
                                                delete yymsp[0].minor.yy21;
                                                objectForTokens = yygotominor.yy4;
                                            }
        break;
      case 64: /* ccons ::= DEFAULT LP expr RP */
{
                                                yygotominor.yy4 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy4->initDefExpr(yymsp[-1].minor.yy490);
                                                objectForTokens = yygotominor.yy4;
                                            }
        break;
      case 65: /* ccons ::= DEFAULT PLUS term */
{
                                                yygotominor.yy4 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy4->initDefTerm(*(yymsp[0].minor.yy21), false);
                                                delete yymsp[0].minor.yy21;
                                                objectForTokens = yygotominor.yy4;
                                            }
        break;
      case 66: /* ccons ::= DEFAULT MINUS term */
{
                                                yygotominor.yy4 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy4->initDefTerm(*(yymsp[0].minor.yy21), true);
                                                delete yymsp[0].minor.yy21;
                                                objectForTokens = yygotominor.yy4;
                                            }
        break;
      case 67: /* ccons ::= DEFAULT id */
{
                                                yygotominor.yy4 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy4->initDefId(*(yymsp[0].minor.yy211));
                                                delete yymsp[0].minor.yy211;
                                                objectForTokens = yygotominor.yy4;
                                            }
        break;
      case 68: /* ccons ::= DEFAULT CTIME_KW */
{
                                                yygotominor.yy4 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy4->initDefCTime(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy4;
                                            }
        break;
      case 69: /* ccons ::= NULL onconf */
{
                                                yygotominor.yy4 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy4->initNull(*(yymsp[0].minor.yy30));
                                                delete yymsp[0].minor.yy30;
                                                objectForTokens = yygotominor.yy4;
                                            }
        break;
      case 70: /* ccons ::= NOT NULL onconf */
{
                                                yygotominor.yy4 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy4->initNotNull(*(yymsp[0].minor.yy30));
                                                delete yymsp[0].minor.yy30;
                                                objectForTokens = yygotominor.yy4;
                                            }
        break;
      case 71: /* ccons ::= PRIMARY KEY sortorder onconf autoinc */
{
                                                yygotominor.yy4 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy4->initPk(*(yymsp[-2].minor.yy226), *(yymsp[-1].minor.yy30), *(yymsp[0].minor.yy237));
                                                delete yymsp[-2].minor.yy226;
                                                delete yymsp[0].minor.yy237;
                                                delete yymsp[-1].minor.yy30;
                                                objectForTokens = yygotominor.yy4;
                                            }
        break;
      case 72: /* ccons ::= UNIQUE onconf */
{
                                                yygotominor.yy4 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy4->initUnique(*(yymsp[0].minor.yy30));
                                                delete yymsp[0].minor.yy30;
                                                objectForTokens = yygotominor.yy4;
                                            }
        break;
      case 73: /* ccons ::= CHECK LP expr RP */
{
                                                yygotominor.yy4 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy4->initCheck(yymsp[-1].minor.yy490);
                                                objectForTokens = yygotominor.yy4;
                                            }
        break;
      case 74: /* ccons ::= REFERENCES nm idxlist_opt refargs */
{
                                                yygotominor.yy4 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy4->initFk(*(yymsp[-2].minor.yy211), *(yymsp[-1].minor.yy139), *(yymsp[0].minor.yy108));
                                                delete yymsp[-2].minor.yy211;
                                                delete yymsp[0].minor.yy108;
                                                delete yymsp[-1].minor.yy139;
                                                objectForTokens = yygotominor.yy4;
                                            }
        break;
      case 75: /* ccons ::= defer_subclause */
{
                                                yygotominor.yy4 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy4->initDefer(yymsp[0].minor.yy131->initially, yymsp[0].minor.yy131->deferrable);
                                                delete yymsp[0].minor.yy131;
                                                objectForTokens = yygotominor.yy4;
                                            }
        break;
      case 76: /* ccons ::= COLLATE ids */
      case 77: /* ccons ::= CONSTRAINT ID_CONSTR */ yytestcase(yyruleno==77);
      case 78: /* ccons ::= COLLATE ID_COLLATE */ yytestcase(yyruleno==78);
      case 79: /* ccons ::= REFERENCES ID_TAB */ yytestcase(yyruleno==79);
{
                                                yygotominor.yy4 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy4->initColl(*(yymsp[0].minor.yy211));
                                                delete yymsp[0].minor.yy211;
                                                objectForTokens = yygotominor.yy4;
                                            }
        break;
      case 80: /* ccons ::= CHECK LP RP */
{
                                                yygotominor.yy4 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy4->initCheck();
                                                objectForTokens = yygotominor.yy4;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 81: /* term ::= NULL */
{yygotominor.yy21 = new QVariant();}
        break;
      case 82: /* term ::= INTEGER */
      case 351: /* number ::= INTEGER */ yytestcase(yyruleno==351);
{yygotominor.yy21 = parserContext->handleNumberToken(yymsp[0].minor.yy0->value);}
        break;
      case 83: /* term ::= FLOAT */
      case 352: /* number ::= FLOAT */ yytestcase(yyruleno==352);
{yygotominor.yy21 = new QVariant(QVariant(yymsp[0].minor.yy0->value).toDouble());}
        break;
      case 84: /* term ::= STRING|BLOB */
      case 345: /* nmnum ::= ON */ yytestcase(yyruleno==345);
      case 346: /* nmnum ::= DELETE */ yytestcase(yyruleno==346);
      case 347: /* nmnum ::= DEFAULT */ yytestcase(yyruleno==347);
{yygotominor.yy21 = new QVariant(yymsp[0].minor.yy0->value);}
        break;
      case 87: /* refargs ::= */
{yygotominor.yy108 = new ParserFkConditionList();}
        break;
      case 88: /* refargs ::= refargs refarg */
{
                                                yymsp[-1].minor.yy108->append(yymsp[0].minor.yy271);
                                                yygotominor.yy108 = yymsp[-1].minor.yy108;
                                                DONT_INHERIT_TOKENS("refargs");
                                            }
        break;
      case 89: /* refarg ::= MATCH nm */
{
                                                yygotominor.yy271 = new SqliteForeignKey::Condition(*(yymsp[0].minor.yy211));
                                                delete yymsp[0].minor.yy211;
                                            }
        break;
      case 90: /* refarg ::= ON INSERT refact */
{yygotominor.yy271 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::INSERT, *(yymsp[0].minor.yy312)); delete yymsp[0].minor.yy312;}
        break;
      case 91: /* refarg ::= ON DELETE refact */
{yygotominor.yy271 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::DELETE, *(yymsp[0].minor.yy312)); delete yymsp[0].minor.yy312;}
        break;
      case 92: /* refarg ::= ON UPDATE refact */
      case 93: /* refarg ::= MATCH ID_FK_MATCH */ yytestcase(yyruleno==93);
{yygotominor.yy271 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::UPDATE, *(yymsp[0].minor.yy312)); delete yymsp[0].minor.yy312;}
        break;
      case 94: /* refact ::= SET NULL */
{yygotominor.yy312 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::SET_NULL);}
        break;
      case 95: /* refact ::= SET DEFAULT */
{yygotominor.yy312 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::SET_DEFAULT);}
        break;
      case 96: /* refact ::= CASCADE */
{yygotominor.yy312 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::CASCADE);}
        break;
      case 97: /* refact ::= RESTRICT */
{yygotominor.yy312 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::RESTRICT);}
        break;
      case 98: /* refact ::= NO ACTION */
{yygotominor.yy312 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::NO_ACTION);}
        break;
      case 99: /* defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt */
{
                                                yygotominor.yy131 = new ParserDeferSubClause(SqliteDeferrable::NOT_DEFERRABLE, *(yymsp[0].minor.yy498));
                                                delete yymsp[0].minor.yy498;
                                            }
        break;
      case 100: /* defer_subclause ::= DEFERRABLE init_deferred_pred_opt */
{
                                                yygotominor.yy131 = new ParserDeferSubClause(SqliteDeferrable::DEFERRABLE, *(yymsp[0].minor.yy498));
                                                delete yymsp[0].minor.yy498;
                                            }
        break;
      case 101: /* init_deferred_pred_opt ::= */
{yygotominor.yy498 = new SqliteInitially(SqliteInitially::null);}
        break;
      case 102: /* init_deferred_pred_opt ::= INITIALLY DEFERRED */
{yygotominor.yy498 = new SqliteInitially(SqliteInitially::DEFERRED);}
        break;
      case 103: /* init_deferred_pred_opt ::= INITIALLY IMMEDIATE */
{yygotominor.yy498 = new SqliteInitially(SqliteInitially::IMMEDIATE);}
        break;
      case 104: /* conslist_opt ::= */
{yygotominor.yy87 = new ParserCreateTableConstraintList();}
        break;
      case 105: /* conslist_opt ::= COMMA conslist */
{yygotominor.yy87 = yymsp[0].minor.yy87;}
        break;
      case 106: /* conslist ::= conslist tconscomma tcons */
{
                                                yymsp[0].minor.yy8->afterComma = *(yymsp[-1].minor.yy237);
                                                yymsp[-2].minor.yy87->append(yymsp[0].minor.yy8);
                                                yygotominor.yy87 = yymsp[-2].minor.yy87;
                                                delete yymsp[-1].minor.yy237;
                                                DONT_INHERIT_TOKENS("conslist");
                                            }
        break;
      case 107: /* conslist ::= tcons */
{
                                                yygotominor.yy87 = new ParserCreateTableConstraintList();
                                                yygotominor.yy87->append(yymsp[0].minor.yy8);
                                            }
        break;
      case 110: /* tcons ::= CONSTRAINT nm */
{
                                                yygotominor.yy8 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy8->initNameOnly(*(yymsp[0].minor.yy211));
                                                delete yymsp[0].minor.yy211;
                                                objectForTokens = yygotominor.yy8;
                                            }
        break;
      case 111: /* tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf */
{
                                                yygotominor.yy8 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy8->initPk(*(yymsp[-3].minor.yy139), *(yymsp[-2].minor.yy237), *(yymsp[0].minor.yy30));
                                                delete yymsp[-2].minor.yy237;
                                                delete yymsp[0].minor.yy30;
                                                delete yymsp[-3].minor.yy139;
                                                objectForTokens = yygotominor.yy8;
                                            }
        break;
      case 112: /* tcons ::= UNIQUE LP idxlist RP onconf */
{
                                                yygotominor.yy8 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy8->initUnique(*(yymsp[-2].minor.yy139), *(yymsp[0].minor.yy30));
                                                delete yymsp[0].minor.yy30;
                                                delete yymsp[-2].minor.yy139;
                                                objectForTokens = yygotominor.yy8;
                                            }
        break;
      case 113: /* tcons ::= CHECK LP expr RP onconf */
{
                                                yygotominor.yy8 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy8->initCheck(yymsp[-2].minor.yy490, *(yymsp[0].minor.yy30));
                                                objectForTokens = yygotominor.yy8;
                                            }
        break;
      case 114: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt */
      case 115: /* tcons ::= CONSTRAINT ID_CONSTR */ yytestcase(yyruleno==115);
      case 116: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES ID_TAB */ yytestcase(yyruleno==116);
{
                                                yygotominor.yy8 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy8->initFk(
                                                    *(yymsp[-6].minor.yy139),
                                                    *(yymsp[-3].minor.yy211),
                                                    *(yymsp[-2].minor.yy139),
                                                    *(yymsp[-1].minor.yy108),
                                                    yymsp[0].minor.yy131->initially,
                                                    yymsp[0].minor.yy131->deferrable
                                                );
                                                delete yymsp[-3].minor.yy211;
                                                delete yymsp[-1].minor.yy108;
                                                delete yymsp[0].minor.yy131;
                                                delete yymsp[-2].minor.yy139;
                                                delete yymsp[-6].minor.yy139;
                                                objectForTokens = yygotominor.yy8;
                                            }
        break;
      case 117: /* tcons ::= CHECK LP RP onconf */
{
                                                yygotominor.yy8 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy8->initCheck();
                                                objectForTokens = yygotominor.yy8;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                              yy_destructor(yypParser,200,&yymsp[0].minor);
}
        break;
      case 118: /* defer_subclause_opt ::= */
{yygotominor.yy131 = new ParserDeferSubClause(SqliteDeferrable::null, SqliteInitially::null);}
        break;
      case 119: /* defer_subclause_opt ::= defer_subclause */
{yygotominor.yy131 = yymsp[0].minor.yy131;}
        break;
      case 120: /* onconf ::= */
      case 122: /* orconf ::= */ yytestcase(yyruleno==122);
{yygotominor.yy30 = new SqliteConflictAlgo(SqliteConflictAlgo::null);}
        break;
      case 121: /* onconf ::= ON CONFLICT resolvetype */
      case 123: /* orconf ::= OR resolvetype */ yytestcase(yyruleno==123);
{yygotominor.yy30 = yymsp[0].minor.yy30;}
        break;
      case 124: /* resolvetype ::= raisetype */
      case 125: /* resolvetype ::= IGNORE */ yytestcase(yyruleno==125);
      case 126: /* resolvetype ::= REPLACE */ yytestcase(yyruleno==126);
{yygotominor.yy30 = new SqliteConflictAlgo(sqliteConflictAlgo(yymsp[0].minor.yy0->value));}
        break;
      case 127: /* cmd ::= DROP TABLE ifexists fullname */
{
                                                yygotominor.yy399 = new SqliteDropTable(*(yymsp[-1].minor.yy237), yymsp[0].minor.yy66->name1, yymsp[0].minor.yy66->name2);
                                                delete yymsp[-1].minor.yy237;
                                                delete yymsp[0].minor.yy66;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 128: /* cmd ::= DROP TABLE ifexists nm DOT ID_TAB */
      case 129: /* cmd ::= DROP TABLE ifexists ID_DB|ID_TAB */ yytestcase(yyruleno==129);
      case 136: /* cmd ::= DROP VIEW ifexists nm DOT ID_VIEW */ yytestcase(yyruleno==136);
      case 137: /* cmd ::= DROP VIEW ifexists ID_DB|ID_VIEW */ yytestcase(yyruleno==137);
      case 178: /* singlesrc ::= nm DOT ID_TAB */ yytestcase(yyruleno==178);
      case 179: /* singlesrc ::= ID_DB|ID_TAB */ yytestcase(yyruleno==179);
      case 180: /* singlesrc ::= nm DOT ID_VIEW */ yytestcase(yyruleno==180);
      case 181: /* singlesrc ::= ID_DB|ID_VIEW */ yytestcase(yyruleno==181);
      case 297: /* exprx ::= nm DOT ID_TAB|ID_COL */ yytestcase(yyruleno==297);
      case 318: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm DOT ID_IDX_NEW */ yytestcase(yyruleno==318);
      case 319: /* cmd ::= CREATE uniqueflag INDEX ifnotexists ID_DB|ID_IDX_NEW */ yytestcase(yyruleno==319);
      case 332: /* cmd ::= DROP INDEX ifexists nm DOT ID_IDX */ yytestcase(yyruleno==332);
      case 333: /* cmd ::= DROP INDEX ifexists ID_DB|ID_IDX */ yytestcase(yyruleno==333);
      case 341: /* cmd ::= PRAGMA nm DOT ID_PRAGMA */ yytestcase(yyruleno==341);
      case 342: /* cmd ::= PRAGMA ID_DB|ID_PRAGMA */ yytestcase(yyruleno==342);
      case 380: /* cmd ::= DROP TRIGGER ifexists nm DOT ID_TRIG */ yytestcase(yyruleno==380);
      case 381: /* cmd ::= DROP TRIGGER ifexists ID_DB|ID_TRIG */ yytestcase(yyruleno==381);
      case 391: /* cmd ::= REINDEX nm DOT ID_TAB|ID_IDX */ yytestcase(yyruleno==391);
      case 392: /* cmd ::= REINDEX ID_DB|ID_IDX|ID_TAB */ yytestcase(yyruleno==392);
      case 395: /* cmd ::= ANALYZE nm DOT ID_TAB|ID_IDX */ yytestcase(yyruleno==395);
      case 396: /* cmd ::= ANALYZE ID_DB|ID_IDX|ID_TAB */ yytestcase(yyruleno==396);
      case 400: /* cmd ::= ALTER TABLE nm DOT ID_TAB */ yytestcase(yyruleno==400);
      case 401: /* cmd ::= ALTER TABLE ID_DB|ID_TAB */ yytestcase(yyruleno==401);
      case 407: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm DOT ID_TAB_NEW */ yytestcase(yyruleno==407);
      case 408: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists ID_DB|ID_TAB_NEW */ yytestcase(yyruleno==408);
{  yy_destructor(yypParser,177,&yymsp[-2].minor);
}
        break;
      case 132: /* cmd ::= CREATE temp VIEW ifnotexists fullname AS select */
{
                                                yygotominor.yy399 = new SqliteCreateView(*(yymsp[-5].minor.yy376), *(yymsp[-3].minor.yy237), yymsp[-2].minor.yy66->name1, yymsp[-2].minor.yy66->name2, yymsp[0].minor.yy123);
                                                delete yymsp[-5].minor.yy376;
                                                delete yymsp[-3].minor.yy237;
                                                delete yymsp[-2].minor.yy66;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 135: /* cmd ::= DROP VIEW ifexists fullname */
{
                                                yygotominor.yy399 = new SqliteDropView(*(yymsp[-1].minor.yy237), yymsp[0].minor.yy66->name1, yymsp[0].minor.yy66->name2);
                                                delete yymsp[-1].minor.yy237;
                                                delete yymsp[0].minor.yy66;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 138: /* cmd ::= select_stmt */
      case 214: /* cmd ::= delete_stmt */ yytestcase(yyruleno==214);
      case 223: /* cmd ::= update_stmt */ yytestcase(yyruleno==223);
      case 235: /* cmd ::= insert_stmt */ yytestcase(yyruleno==235);
{
                                                yygotominor.yy399 = yymsp[0].minor.yy399;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 139: /* select_stmt ::= select */
{
                                                yygotominor.yy399 = yymsp[0].minor.yy123;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 140: /* select ::= with selectnowith */
{
                                                yygotominor.yy123 = yymsp[0].minor.yy123;
                                                yymsp[0].minor.yy123->setWith(yymsp[-1].minor.yy367);
                                                objectForTokens = yygotominor.yy123;
                                            }
        break;
      case 141: /* selectnowith ::= oneselect */
{
                                                yygotominor.yy123 = SqliteSelect::append(yymsp[0].minor.yy468);
                                                objectForTokens = yygotominor.yy123;
                                            }
        break;
      case 142: /* selectnowith ::= selectnowith multiselect_op oneselect */
{
                                                yygotominor.yy123 = SqliteSelect::append(yymsp[-2].minor.yy123, *(yymsp[-1].minor.yy168), yymsp[0].minor.yy468);
                                                delete yymsp[-1].minor.yy168;
                                                objectForTokens = yygotominor.yy123;
                                            }
        break;
      case 143: /* selectnowith ::= values */
{
                                                yygotominor.yy123 = SqliteSelect::append(*(yymsp[0].minor.yy416));
                                                delete yymsp[0].minor.yy416;
                                                objectForTokens = yygotominor.yy123;
                                            }
        break;
      case 144: /* selectnowith ::= selectnowith COMMA values */
{
                                                yygotominor.yy123 = SqliteSelect::append(yymsp[-2].minor.yy123, SqliteSelect::CompoundOperator::UNION_ALL, *(yymsp[0].minor.yy416));
                                                delete yymsp[0].minor.yy416;
                                                objectForTokens = yygotominor.yy123;
                                            }
        break;
      case 145: /* multiselect_op ::= UNION */
{yygotominor.yy168 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::UNION);}
        break;
      case 146: /* multiselect_op ::= UNION ALL */
{yygotominor.yy168 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::UNION_ALL);}
        break;
      case 147: /* multiselect_op ::= EXCEPT */
{yygotominor.yy168 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::EXCEPT);}
        break;
      case 148: /* multiselect_op ::= INTERSECT */
{yygotominor.yy168 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::INTERSECT);}
        break;
      case 149: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
{
                                                yygotominor.yy468 = new SqliteSelect::Core(
                                                        *(yymsp[-7].minor.yy376),
                                                        *(yymsp[-6].minor.yy263),
                                                        yymsp[-5].minor.yy373,
                                                        yymsp[-4].minor.yy490,
                                                        *(yymsp[-3].minor.yy13),
                                                        yymsp[-2].minor.yy490,
                                                        *(yymsp[-1].minor.yy495),
                                                        yymsp[0].minor.yy128
                                                    );
                                                delete yymsp[-6].minor.yy263;
                                                delete yymsp[-7].minor.yy376;
                                                delete yymsp[-3].minor.yy13;
                                                delete yymsp[-1].minor.yy495;
                                                objectForTokens = yygotominor.yy468;
                                            }
        break;
      case 150: /* values ::= VALUES LP nexprlist RP */
{
                                                yygotominor.yy416 = new ParserExprNestedList();
                                                yygotominor.yy416->append(*(yymsp[-1].minor.yy13));
                                                delete yymsp[-1].minor.yy13;
                                            }
        break;
      case 151: /* values ::= values COMMA LP exprlist RP */
{
                                                yymsp[-4].minor.yy416->append(*(yymsp[-1].minor.yy13));
                                                yygotominor.yy416 = yymsp[-4].minor.yy416;
                                                delete yymsp[-1].minor.yy13;
                                                DONT_INHERIT_TOKENS("values");
                                            }
        break;
      case 152: /* distinct ::= DISTINCT */
{yygotominor.yy376 = new int(1);}
        break;
      case 153: /* distinct ::= ALL */
{yygotominor.yy376 = new int(2);}
        break;
      case 155: /* sclp ::= selcollist COMMA */
{yygotominor.yy263 = yymsp[-1].minor.yy263;}
        break;
      case 156: /* sclp ::= */
{yygotominor.yy263 = new ParserResultColumnList();}
        break;
      case 157: /* selcollist ::= sclp expr as */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(
                                                        yymsp[-1].minor.yy490,
                                                        yymsp[0].minor.yy28 ? yymsp[0].minor.yy28->asKw : false,
                                                        yymsp[0].minor.yy28 ? yymsp[0].minor.yy28->name : QString::null
                                                    );

                                                yymsp[-2].minor.yy263->append(obj);
                                                yygotominor.yy263 = yymsp[-2].minor.yy263;
                                                delete yymsp[0].minor.yy28;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 158: /* selcollist ::= sclp STAR */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(true);

                                                yymsp[-1].minor.yy263->append(obj);
                                                yygotominor.yy263 = yymsp[-1].minor.yy263;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 159: /* selcollist ::= sclp nm DOT STAR */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(
                                                        true,
                                                        *(yymsp[-2].minor.yy211)
                                                    );
                                                yymsp[-3].minor.yy263->append(obj);
                                                yygotominor.yy263 = yymsp[-3].minor.yy263;
                                                delete yymsp[-2].minor.yy211;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 160: /* selcollist ::= sclp */
      case 161: /* selcollist ::= sclp ID_TAB DOT STAR */ yytestcase(yyruleno==161);
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy263 = yymsp[0].minor.yy263;
                                            }
        break;
      case 162: /* as ::= AS nm */
{
                                                yygotominor.yy28 = new ParserStubAlias(*(yymsp[0].minor.yy211), true);
                                                delete yymsp[0].minor.yy211;
                                            }
        break;
      case 163: /* as ::= ids */
      case 164: /* as ::= AS ID_ALIAS */ yytestcase(yyruleno==164);
      case 165: /* as ::= ID_ALIAS */ yytestcase(yyruleno==165);
{
                                                yygotominor.yy28 = new ParserStubAlias(*(yymsp[0].minor.yy211), false);
                                                delete yymsp[0].minor.yy211;
                                            }
        break;
      case 166: /* as ::= */
{yygotominor.yy28 = nullptr;}
        break;
      case 167: /* from ::= */
{yygotominor.yy373 = nullptr;}
        break;
      case 168: /* from ::= FROM joinsrc */
{yygotominor.yy373 = yymsp[0].minor.yy373;}
        break;
      case 169: /* joinsrc ::= singlesrc seltablist */
{
                                                yygotominor.yy373 = new SqliteSelect::Core::JoinSource(
                                                        yymsp[-1].minor.yy173,
                                                        *(yymsp[0].minor.yy359)
                                                    );
                                                delete yymsp[0].minor.yy359;
                                                objectForTokens = yygotominor.yy373;
                                            }
        break;
      case 170: /* joinsrc ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy373 = new SqliteSelect::Core::JoinSource();
                                                objectForTokens = yygotominor.yy373;
                                            }
        break;
      case 171: /* seltablist ::= seltablist joinop singlesrc joinconstr_opt */
{
                                                SqliteSelect::Core::JoinSourceOther* src =
                                                    new SqliteSelect::Core::JoinSourceOther(yymsp[-2].minor.yy473, yymsp[-1].minor.yy173, yymsp[0].minor.yy117);

                                                yymsp[-3].minor.yy359->append(src);
                                                yygotominor.yy359 = yymsp[-3].minor.yy359;
                                                objectForTokens = src;
                                                DONT_INHERIT_TOKENS("seltablist");
                                            }
        break;
      case 172: /* seltablist ::= */
{
                                                yygotominor.yy359 = new ParserOtherSourceList();
                                            }
        break;
      case 173: /* singlesrc ::= nm dbnm as indexed_opt */
{
                                                yygotominor.yy173 = new SqliteSelect::Core::SingleSource(
                                                        *(yymsp[-3].minor.yy211),
                                                        *(yymsp[-2].minor.yy211),
                                                        yymsp[-1].minor.yy28 ? yymsp[-1].minor.yy28->asKw : false,
                                                        yymsp[-1].minor.yy28 ? yymsp[-1].minor.yy28->name : QString::null,
                                                        yymsp[0].minor.yy472 ? yymsp[0].minor.yy472->notIndexedKw : false,
                                                        yymsp[0].minor.yy472 ? yymsp[0].minor.yy472->indexedBy : QString::null
                                                    );
                                                delete yymsp[-3].minor.yy211;
                                                delete yymsp[-2].minor.yy211;
                                                delete yymsp[-1].minor.yy28;
                                                if (yymsp[0].minor.yy472)
                                                    delete yymsp[0].minor.yy472;
                                                objectForTokens = yygotominor.yy173;
                                            }
        break;
      case 174: /* singlesrc ::= LP select RP as */
{
                                                yygotominor.yy173 = new SqliteSelect::Core::SingleSource(
                                                        yymsp[-2].minor.yy123,
                                                        yymsp[0].minor.yy28 ? yymsp[0].minor.yy28->asKw : false,
                                                        yymsp[0].minor.yy28 ? yymsp[0].minor.yy28->name : QString::null
                                                    );
                                                delete yymsp[0].minor.yy28;
                                                objectForTokens = yygotominor.yy173;
                                            }
        break;
      case 175: /* singlesrc ::= LP joinsrc RP as */
{
                                                yygotominor.yy173 = new SqliteSelect::Core::SingleSource(
                                                        yymsp[-2].minor.yy373,
                                                        yymsp[0].minor.yy28 ? yymsp[0].minor.yy28->asKw : false,
                                                        yymsp[0].minor.yy28 ? yymsp[0].minor.yy28->name : QString::null
                                                    );
                                                delete yymsp[0].minor.yy28;
                                                objectForTokens = yygotominor.yy173;
                                            }
        break;
      case 176: /* singlesrc ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy173 = new SqliteSelect::Core::SingleSource();
                                                objectForTokens = yygotominor.yy173;
                                            }
        break;
      case 177: /* singlesrc ::= nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy173 = new SqliteSelect::Core::SingleSource();
                                                yygotominor.yy173->database = *(yymsp[-1].minor.yy211);
                                                delete yymsp[-1].minor.yy211;
                                                objectForTokens = yygotominor.yy173;
                                            }
        break;
      case 182: /* joinconstr_opt ::= ON expr */
{
                                                yygotominor.yy117 = new SqliteSelect::Core::JoinConstraint(yymsp[0].minor.yy490);
                                                objectForTokens = yygotominor.yy117;
                                            }
        break;
      case 183: /* joinconstr_opt ::= USING LP inscollist RP */
{
                                                yygotominor.yy117 = new SqliteSelect::Core::JoinConstraint(*(yymsp[-1].minor.yy445));
                                                delete yymsp[-1].minor.yy445;
                                                objectForTokens = yygotominor.yy117;
                                            }
        break;
      case 184: /* joinconstr_opt ::= */
{yygotominor.yy117 = nullptr;}
        break;
      case 187: /* fullname ::= nm dbnm */
{
                                                yygotominor.yy66 = new ParserFullName();
                                                yygotominor.yy66->name1 = *(yymsp[-1].minor.yy211);
                                                yygotominor.yy66->name2 = *(yymsp[0].minor.yy211);
                                                delete yymsp[-1].minor.yy211;
                                                delete yymsp[0].minor.yy211;
                                            }
        break;
      case 188: /* joinop ::= COMMA */
{
                                                yygotominor.yy473 = new SqliteSelect::Core::JoinOp(true);
                                                objectForTokens = yygotominor.yy473;
                                            }
        break;
      case 189: /* joinop ::= JOIN */
{
                                                yygotominor.yy473 = new SqliteSelect::Core::JoinOp(false);
                                                objectForTokens = yygotominor.yy473;
                                            }
        break;
      case 190: /* joinop ::= JOIN_KW JOIN */
{
                                                yygotominor.yy473 = new SqliteSelect::Core::JoinOp(yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy473;
                                            }
        break;
      case 191: /* joinop ::= JOIN_KW nm JOIN */
{
                                                yygotominor.yy473 = new SqliteSelect::Core::JoinOp(yymsp[-2].minor.yy0->value, *(yymsp[-1].minor.yy211));
                                                delete yymsp[-1].minor.yy211;
                                                objectForTokens = yygotominor.yy473;
                                            }
        break;
      case 192: /* joinop ::= JOIN_KW nm nm JOIN */
      case 193: /* joinop ::= ID_JOIN_OPTS */ yytestcase(yyruleno==193);
{
                                                yygotominor.yy473 = new SqliteSelect::Core::JoinOp(yymsp[-3].minor.yy0->value, *(yymsp[-2].minor.yy211), *(yymsp[-1].minor.yy211));
                                                delete yymsp[-2].minor.yy211;
                                                delete yymsp[-2].minor.yy211;
                                                objectForTokens = yygotominor.yy473;
                                            }
        break;
      case 194: /* indexed_opt ::= */
{yygotominor.yy472 = nullptr;}
        break;
      case 195: /* indexed_opt ::= INDEXED BY nm */
{
                                                yygotominor.yy472 = new ParserIndexedBy(*(yymsp[0].minor.yy211));
                                                delete yymsp[0].minor.yy211;
                                            }
        break;
      case 196: /* indexed_opt ::= NOT INDEXED */
      case 197: /* indexed_opt ::= INDEXED BY ID_IDX */ yytestcase(yyruleno==197);
{yygotominor.yy472 = new ParserIndexedBy(true);}
        break;
      case 198: /* orderby_opt ::= */
{yygotominor.yy495 = new ParserOrderByList();}
        break;
      case 199: /* orderby_opt ::= ORDER BY sortlist */
{yygotominor.yy495 = yymsp[0].minor.yy495;}
        break;
      case 200: /* sortlist ::= sortlist COMMA expr sortorder */
{
                                                SqliteOrderBy* obj = new SqliteOrderBy(yymsp[-1].minor.yy490, *(yymsp[0].minor.yy226));
                                                yymsp[-3].minor.yy495->append(obj);
                                                yygotominor.yy495 = yymsp[-3].minor.yy495;
                                                delete yymsp[0].minor.yy226;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sortlist");
                                            }
        break;
      case 201: /* sortlist ::= expr sortorder */
{
                                                SqliteOrderBy* obj = new SqliteOrderBy(yymsp[-1].minor.yy490, *(yymsp[0].minor.yy226));
                                                yygotominor.yy495 = new ParserOrderByList();
                                                yygotominor.yy495->append(obj);
                                                delete yymsp[0].minor.yy226;
                                                objectForTokens = obj;
                                            }
        break;
      case 202: /* sortorder ::= ASC */
{yygotominor.yy226 = new SqliteSortOrder(SqliteSortOrder::ASC);}
        break;
      case 203: /* sortorder ::= DESC */
{yygotominor.yy226 = new SqliteSortOrder(SqliteSortOrder::DESC);}
        break;
      case 204: /* sortorder ::= */
{yygotominor.yy226 = new SqliteSortOrder(SqliteSortOrder::null);}
        break;
      case 205: /* groupby_opt ::= */
      case 313: /* exprlist ::= */ yytestcase(yyruleno==313);
{yygotominor.yy13 = new ParserExprList();}
        break;
      case 206: /* groupby_opt ::= GROUP BY nexprlist */
      case 312: /* exprlist ::= nexprlist */ yytestcase(yyruleno==312);
{yygotominor.yy13 = yymsp[0].minor.yy13;}
        break;
      case 207: /* groupby_opt ::= GROUP BY */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy13 = new ParserExprList();
                                            }
        break;
      case 208: /* having_opt ::= */
      case 220: /* where_opt ::= */ yytestcase(yyruleno==220);
      case 309: /* case_else ::= */ yytestcase(yyruleno==309);
      case 311: /* case_operand ::= */ yytestcase(yyruleno==311);
      case 369: /* when_clause ::= */ yytestcase(yyruleno==369);
      case 384: /* key_opt ::= */ yytestcase(yyruleno==384);
{yygotominor.yy490 = nullptr;}
        break;
      case 209: /* having_opt ::= HAVING expr */
      case 221: /* where_opt ::= WHERE expr */ yytestcase(yyruleno==221);
      case 301: /* expr ::= exprx */ yytestcase(yyruleno==301);
      case 308: /* case_else ::= ELSE expr */ yytestcase(yyruleno==308);
      case 310: /* case_operand ::= exprx */ yytestcase(yyruleno==310);
      case 370: /* when_clause ::= WHEN expr */ yytestcase(yyruleno==370);
      case 385: /* key_opt ::= KEY expr */ yytestcase(yyruleno==385);
{yygotominor.yy490 = yymsp[0].minor.yy490;}
        break;
      case 210: /* limit_opt ::= */
{yygotominor.yy128 = nullptr;}
        break;
      case 211: /* limit_opt ::= LIMIT expr */
{
                                                yygotominor.yy128 = new SqliteLimit(yymsp[0].minor.yy490);
                                                objectForTokens = yygotominor.yy128;
                                            }
        break;
      case 212: /* limit_opt ::= LIMIT expr OFFSET expr */
{
                                                yygotominor.yy128 = new SqliteLimit(yymsp[-2].minor.yy490, yymsp[0].minor.yy490, true);
                                                objectForTokens = yygotominor.yy128;
                                            }
        break;
      case 213: /* limit_opt ::= LIMIT expr COMMA expr */
{
                                                yygotominor.yy128 = new SqliteLimit(yymsp[-2].minor.yy490, yymsp[0].minor.yy490, false);
                                                objectForTokens = yygotominor.yy128;
                                            }
        break;
      case 215: /* delete_stmt ::= with DELETE FROM fullname indexed_opt where_opt */
{
                                                if (yymsp[-1].minor.yy472)
                                                {
                                                    if (!yymsp[-1].minor.yy472->indexedBy.isNull())
                                                    {
                                                        yygotominor.yy399 = new SqliteDelete(
                                                                yymsp[-2].minor.yy66->name1,
                                                                yymsp[-2].minor.yy66->name2,
                                                                yymsp[-1].minor.yy472->indexedBy,
                                                                yymsp[0].minor.yy490,
                                                                yymsp[-5].minor.yy367
                                                            );
                                                    }
                                                    else
                                                    {
                                                        yygotominor.yy399 = new SqliteDelete(
                                                                yymsp[-2].minor.yy66->name1,
                                                                yymsp[-2].minor.yy66->name2,
                                                                yymsp[-1].minor.yy472->notIndexedKw,
                                                                yymsp[0].minor.yy490,
                                                                yymsp[-5].minor.yy367
                                                            );
                                                    }
                                                    delete yymsp[-1].minor.yy472;
                                                }
                                                else
                                                {
                                                    yygotominor.yy399 = new SqliteDelete(
                                                            yymsp[-2].minor.yy66->name1,
                                                            yymsp[-2].minor.yy66->name2,
                                                            false,
                                                            yymsp[0].minor.yy490,
                                                            yymsp[-5].minor.yy367
                                                        );
                                                }
                                                delete yymsp[-2].minor.yy66;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 216: /* delete_stmt ::= with DELETE FROM */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteDelete* q = new SqliteDelete();
                                                q->with = yymsp[-2].minor.yy367;
                                                yygotominor.yy399 = q;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 217: /* delete_stmt ::= with DELETE FROM nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteDelete* q = new SqliteDelete();
                                                q->with = yymsp[-4].minor.yy367;
                                                q->database = *(yymsp[-1].minor.yy211);
                                                yygotominor.yy399 = q;
                                                objectForTokens = yygotominor.yy399;
                                                delete yymsp[-1].minor.yy211;
                                            }
        break;
      case 218: /* delete_stmt ::= with DELETE FROM nm DOT ID_TAB */
      case 227: /* update_stmt ::= with UPDATE orconf nm DOT ID_TAB */ yytestcase(yyruleno==227);
{  yy_destructor(yypParser,219,&yymsp[-5].minor);
  yy_destructor(yypParser,177,&yymsp[-2].minor);
}
        break;
      case 219: /* delete_stmt ::= with DELETE FROM ID_DB|ID_TAB */
      case 228: /* update_stmt ::= with UPDATE orconf ID_DB|ID_TAB */ yytestcase(yyruleno==228);
{  yy_destructor(yypParser,219,&yymsp[-3].minor);
}
        break;
      case 222: /* where_opt ::= WHERE */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy490 = new SqliteExpr();
                                            }
        break;
      case 224: /* update_stmt ::= with UPDATE orconf fullname indexed_opt SET setlist where_opt */
{
                                                yygotominor.yy399 = new SqliteUpdate(
                                                        *(yymsp[-5].minor.yy30),
                                                        yymsp[-4].minor.yy66->name1,
                                                        yymsp[-4].minor.yy66->name2,
                                                        yymsp[-3].minor.yy472 ? yymsp[-3].minor.yy472->notIndexedKw : false,
                                                        yymsp[-3].minor.yy472 ? yymsp[-3].minor.yy472->indexedBy : QString::null,
                                                        *(yymsp[-1].minor.yy381),
                                                        yymsp[0].minor.yy490,
                                                        yymsp[-7].minor.yy367
                                                    );
                                                delete yymsp[-5].minor.yy30;
                                                delete yymsp[-4].minor.yy66;
                                                delete yymsp[-1].minor.yy381;
                                                if (yymsp[-3].minor.yy472)
                                                    delete yymsp[-3].minor.yy472;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 225: /* update_stmt ::= with UPDATE orconf */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteUpdate* q = new SqliteUpdate();
                                                q->with = yymsp[-2].minor.yy367;
                                                yygotominor.yy399 = q;
                                                objectForTokens = yygotominor.yy399;
                                                delete yymsp[0].minor.yy30;
                                            }
        break;
      case 226: /* update_stmt ::= with UPDATE orconf nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteUpdate* q = new SqliteUpdate();
                                                q->with = yymsp[-4].minor.yy367;
                                                q->database = *(yymsp[-1].minor.yy211);
                                                yygotominor.yy399 = q;
                                                objectForTokens = yygotominor.yy399;
                                                delete yymsp[-2].minor.yy30;
                                                delete yymsp[-1].minor.yy211;
                                            }
        break;
      case 229: /* setlist ::= setlist COMMA nm EQ expr */
{
                                                yymsp[-4].minor.yy381->append(ParserSetValue(*(yymsp[-2].minor.yy211), yymsp[0].minor.yy490));
                                                yygotominor.yy381 = yymsp[-4].minor.yy381;
                                                delete yymsp[-2].minor.yy211;
                                                DONT_INHERIT_TOKENS("setlist");
                                            }
        break;
      case 230: /* setlist ::= nm EQ expr */
{
                                                yygotominor.yy381 = new ParserSetValueList();
                                                yygotominor.yy381->append(ParserSetValue(*(yymsp[-2].minor.yy211), yymsp[0].minor.yy490));
                                                delete yymsp[-2].minor.yy211;
                                            }
        break;
      case 231: /* setlist ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy381 = new ParserSetValueList();
                                            }
        break;
      case 232: /* setlist ::= setlist COMMA */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy381 = yymsp[-1].minor.yy381;
                                            }
        break;
      case 233: /* setlist ::= setlist COMMA ID_COL */
      case 234: /* setlist ::= ID_COL */ yytestcase(yyruleno==234);
{  yy_destructor(yypParser,247,&yymsp[-2].minor);
}
        break;
      case 236: /* insert_stmt ::= with insert_cmd INTO fullname inscollist_opt select */
{
                                                yygotominor.yy399 = new SqliteInsert(
                                                        yymsp[-4].minor.yy250->replace,
                                                        yymsp[-4].minor.yy250->orConflict,
                                                        yymsp[-2].minor.yy66->name1,
                                                        yymsp[-2].minor.yy66->name2,
                                                        *(yymsp[-1].minor.yy445),
                                                        yymsp[0].minor.yy123,
                                                        yymsp[-5].minor.yy367
                                                    );
                                                delete yymsp[-2].minor.yy66;
                                                delete yymsp[-4].minor.yy250;
                                                delete yymsp[-1].minor.yy445;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 237: /* insert_stmt ::= with insert_cmd INTO fullname inscollist_opt DEFAULT VALUES */
{
                                                yygotominor.yy399 = new SqliteInsert(
                                                        yymsp[-5].minor.yy250->replace,
                                                        yymsp[-5].minor.yy250->orConflict,
                                                        yymsp[-3].minor.yy66->name1,
                                                        yymsp[-3].minor.yy66->name2,
                                                        *(yymsp[-2].minor.yy445),
                                                        yymsp[-6].minor.yy367
                                                    );
                                                delete yymsp[-3].minor.yy66;
                                                delete yymsp[-5].minor.yy250;
                                                delete yymsp[-2].minor.yy445;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 238: /* insert_stmt ::= with insert_cmd INTO */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteInsert* q = new SqliteInsert();
                                                q->replaceKw = yymsp[-1].minor.yy250->replace;
                                                q->onConflict = yymsp[-1].minor.yy250->orConflict;
                                                q->with = yymsp[-2].minor.yy367;
                                                yygotominor.yy399 = q;
                                                objectForTokens = yygotominor.yy399;
                                                delete yymsp[-1].minor.yy250;
                                            }
        break;
      case 239: /* insert_stmt ::= with insert_cmd INTO nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteInsert* q = new SqliteInsert();
                                                q->replaceKw = yymsp[-3].minor.yy250->replace;
                                                q->onConflict = yymsp[-3].minor.yy250->orConflict;
                                                q->with = yymsp[-4].minor.yy367;
                                                q->database = *(yymsp[-1].minor.yy211);
                                                yygotominor.yy399 = q;
                                                objectForTokens = yygotominor.yy399;
                                                delete yymsp[-3].minor.yy250;
                                                delete yymsp[-1].minor.yy211;
                                            }
        break;
      case 240: /* insert_stmt ::= with insert_cmd INTO ID_DB|ID_TAB */
{  yy_destructor(yypParser,219,&yymsp[-3].minor);
  yy_destructor(yypParser,249,&yymsp[-2].minor);
}
        break;
      case 241: /* insert_stmt ::= with insert_cmd INTO nm DOT ID_TAB */
{  yy_destructor(yypParser,219,&yymsp[-5].minor);
  yy_destructor(yypParser,249,&yymsp[-4].minor);
  yy_destructor(yypParser,177,&yymsp[-2].minor);
}
        break;
      case 242: /* insert_cmd ::= INSERT orconf */
{
                                                yygotominor.yy250 = new ParserStubInsertOrReplace(false, *(yymsp[0].minor.yy30));
                                                delete yymsp[0].minor.yy30;
                                            }
        break;
      case 243: /* insert_cmd ::= REPLACE */
{yygotominor.yy250 = new ParserStubInsertOrReplace(true);}
        break;
      case 244: /* inscollist_opt ::= */
{yygotominor.yy445 = new ParserStringList();}
        break;
      case 245: /* inscollist_opt ::= LP inscollist RP */
{yygotominor.yy445 = yymsp[-1].minor.yy445;}
        break;
      case 246: /* inscollist ::= inscollist COMMA nm */
{
                                                yymsp[-2].minor.yy445->append(*(yymsp[0].minor.yy211));
                                                yygotominor.yy445 = yymsp[-2].minor.yy445;
                                                delete yymsp[0].minor.yy211;
                                                DONT_INHERIT_TOKENS("inscollist");
                                            }
        break;
      case 247: /* inscollist ::= nm */
{
                                                yygotominor.yy445 = new ParserStringList();
                                                yygotominor.yy445->append(*(yymsp[0].minor.yy211));
                                                delete yymsp[0].minor.yy211;
                                            }
        break;
      case 248: /* inscollist ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy445 = new ParserStringList();
                                            }
        break;
      case 249: /* inscollist ::= inscollist COMMA ID_COL */
      case 250: /* inscollist ::= ID_COL */ yytestcase(yyruleno==250);
{  yy_destructor(yypParser,243,&yymsp[-2].minor);
}
        break;
      case 251: /* exprx ::= term */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initLiteral(*(yymsp[0].minor.yy21));
                                                delete yymsp[0].minor.yy21;
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 252: /* exprx ::= CTIME_KW */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initCTime(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 253: /* exprx ::= LP expr RP */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initSubExpr(yymsp[-1].minor.yy490);
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 254: /* exprx ::= id */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initId(*(yymsp[0].minor.yy211));
                                                delete yymsp[0].minor.yy211;
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 255: /* exprx ::= JOIN_KW */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initId(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 256: /* exprx ::= nm DOT nm */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initId(*(yymsp[-2].minor.yy211), *(yymsp[0].minor.yy211));
                                                delete yymsp[-2].minor.yy211;
                                                delete yymsp[0].minor.yy211;
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 257: /* exprx ::= nm DOT nm DOT nm */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initId(*(yymsp[-4].minor.yy211), *(yymsp[-2].minor.yy211), *(yymsp[0].minor.yy211));
                                                delete yymsp[-4].minor.yy211;
                                                delete yymsp[-2].minor.yy211;
                                                delete yymsp[0].minor.yy211;
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 258: /* exprx ::= VARIABLE */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initBindParam(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 259: /* exprx ::= expr COLLATE ids */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initCollate(yymsp[-2].minor.yy490, *(yymsp[0].minor.yy211));
                                                delete yymsp[0].minor.yy211;
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 260: /* exprx ::= CAST LP expr AS typetoken RP */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initCast(yymsp[-3].minor.yy490, yymsp[-1].minor.yy299);
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 261: /* exprx ::= ID LP distinct exprlist RP */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initFunction(yymsp[-4].minor.yy0->value, *(yymsp[-2].minor.yy376), *(yymsp[-1].minor.yy13));
                                                delete yymsp[-2].minor.yy376;
                                                delete yymsp[-1].minor.yy13;
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 262: /* exprx ::= ID LP STAR RP */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initFunction(yymsp[-3].minor.yy0->value, true);
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 263: /* exprx ::= expr AND expr */
      case 264: /* exprx ::= expr OR expr */ yytestcase(yyruleno==264);
      case 265: /* exprx ::= expr LT|GT|GE|LE expr */ yytestcase(yyruleno==265);
      case 266: /* exprx ::= expr EQ|NE expr */ yytestcase(yyruleno==266);
      case 267: /* exprx ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr */ yytestcase(yyruleno==267);
      case 268: /* exprx ::= expr PLUS|MINUS expr */ yytestcase(yyruleno==268);
      case 269: /* exprx ::= expr STAR|SLASH|REM expr */ yytestcase(yyruleno==269);
      case 270: /* exprx ::= expr CONCAT expr */ yytestcase(yyruleno==270);
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initBinOp(yymsp[-2].minor.yy490, yymsp[-1].minor.yy0->value, yymsp[0].minor.yy490);
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 271: /* exprx ::= expr not_opt likeop expr */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initLike(yymsp[-3].minor.yy490, *(yymsp[-2].minor.yy237), *(yymsp[-1].minor.yy374), yymsp[0].minor.yy490);
                                                delete yymsp[-2].minor.yy237;
                                                delete yymsp[-1].minor.yy374;
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 272: /* exprx ::= expr not_opt likeop expr ESCAPE expr */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initLike(yymsp[-5].minor.yy490, *(yymsp[-4].minor.yy237), *(yymsp[-3].minor.yy374), yymsp[-2].minor.yy490, yymsp[0].minor.yy490);
                                                delete yymsp[-4].minor.yy237;
                                                delete yymsp[-3].minor.yy374;
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 273: /* exprx ::= expr ISNULL|NOTNULL */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initNull(yymsp[-1].minor.yy490, yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 274: /* exprx ::= expr NOT NULL */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initNull(yymsp[-2].minor.yy490, "NOT NULL");
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 275: /* exprx ::= expr IS not_opt expr */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initIs(yymsp[-3].minor.yy490, *(yymsp[-1].minor.yy237), yymsp[0].minor.yy490);
                                                delete yymsp[-1].minor.yy237;
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 276: /* exprx ::= NOT expr */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initUnaryOp(yymsp[0].minor.yy490, yymsp[-1].minor.yy0->value);
                                            }
        break;
      case 277: /* exprx ::= BITNOT expr */
      case 279: /* exprx ::= PLUS expr */ yytestcase(yyruleno==279);
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initUnaryOp(yymsp[0].minor.yy490, yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 278: /* exprx ::= MINUS expr */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                if (yymsp[0].minor.yy490->mode == SqliteExpr::Mode::LITERAL_VALUE &&
                                                    parserContext->isCandidateForMaxNegativeNumber() &&
                                                    yymsp[0].minor.yy490->literalValue == static_cast<qint64>(0L))
                                                {
                                                    yygotominor.yy490->initLiteral(std::numeric_limits<qint64>::min());
                                                    delete yymsp[0].minor.yy490;
                                                }
                                                else
                                                {
                                                    yygotominor.yy490->initUnaryOp(yymsp[0].minor.yy490, yymsp[-1].minor.yy0->value);
                                                }
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 280: /* exprx ::= expr not_opt BETWEEN expr AND expr */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initBetween(yymsp[-5].minor.yy490, *(yymsp[-4].minor.yy237), yymsp[-2].minor.yy490, yymsp[0].minor.yy490);
                                                delete yymsp[-4].minor.yy237;
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 281: /* exprx ::= expr not_opt IN LP exprlist RP */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initIn(yymsp[-5].minor.yy490, *(yymsp[-4].minor.yy237), *(yymsp[-1].minor.yy13));
                                                delete yymsp[-4].minor.yy237;
                                                delete yymsp[-1].minor.yy13;
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 282: /* exprx ::= LP select RP */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initSubSelect(yymsp[-1].minor.yy123);
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 283: /* exprx ::= expr not_opt IN LP select RP */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initIn(yymsp[-5].minor.yy490, *(yymsp[-4].minor.yy237), yymsp[-1].minor.yy123);
                                                delete yymsp[-4].minor.yy237;
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 284: /* exprx ::= expr not_opt IN nm dbnm */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initIn(yymsp[-4].minor.yy490, *(yymsp[-3].minor.yy237), *(yymsp[-1].minor.yy211), *(yymsp[0].minor.yy211));
                                                delete yymsp[-3].minor.yy237;
                                                delete yymsp[-1].minor.yy211;
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 285: /* exprx ::= EXISTS LP select RP */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initExists(yymsp[-1].minor.yy123);
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 286: /* exprx ::= CASE case_operand case_exprlist case_else END */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initCase(yymsp[-3].minor.yy490, *(yymsp[-2].minor.yy13), yymsp[-1].minor.yy490);
                                                delete yymsp[-2].minor.yy13;
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 287: /* exprx ::= RAISE LP IGNORE RP */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initRaise(yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 288: /* exprx ::= RAISE LP raisetype COMMA nm RP */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initRaise(yymsp[-3].minor.yy0->value, *(yymsp[-1].minor.yy211));
                                                delete yymsp[-1].minor.yy211;
                                                objectForTokens = yygotominor.yy490;
                                            }
        break;
      case 289: /* exprx ::= nm DOT */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initId(*(yymsp[-1].minor.yy211), QString::null, QString::null);
                                                delete yymsp[-1].minor.yy211;
                                                objectForTokens = yygotominor.yy490;
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                            }
        break;
      case 290: /* exprx ::= nm DOT nm DOT */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                yygotominor.yy490->initId(*(yymsp[-3].minor.yy211), *(yymsp[-1].minor.yy211), QString::null);
                                                delete yymsp[-3].minor.yy211;
                                                delete yymsp[-1].minor.yy211;
                                                objectForTokens = yygotominor.yy490;
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                            }
        break;
      case 291: /* exprx ::= expr not_opt BETWEEN expr AND */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                delete yymsp[-3].minor.yy237;
                                                delete yymsp[-4].minor.yy490;
                                                delete yymsp[-1].minor.yy490;
                                                objectForTokens = yygotominor.yy490;
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                            }
        break;
      case 292: /* exprx ::= CASE case_operand case_exprlist case_else */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                delete yymsp[-1].minor.yy13;
                                                delete yymsp[-2].minor.yy490;
                                                delete yymsp[0].minor.yy490;
                                                objectForTokens = yygotominor.yy490;
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                            }
        break;
      case 293: /* exprx ::= expr not_opt IN LP exprlist */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                delete yymsp[-3].minor.yy237;
                                                delete yymsp[0].minor.yy13;
                                                delete yymsp[-4].minor.yy490;
                                                objectForTokens = yygotominor.yy490;
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                            }
        break;
      case 294: /* exprx ::= expr not_opt IN ID_DB */
{  yy_destructor(yypParser,199,&yymsp[-3].minor);
}
        break;
      case 295: /* exprx ::= expr not_opt IN nm DOT ID_TAB */
      case 296: /* exprx ::= ID_DB|ID_TAB|ID_COL|ID_FN */ yytestcase(yyruleno==296);
{  yy_destructor(yypParser,199,&yymsp[-5].minor);
  yy_destructor(yypParser,177,&yymsp[-2].minor);
}
        break;
      case 298: /* exprx ::= nm DOT nm DOT ID_COL */
{  yy_destructor(yypParser,177,&yymsp[-4].minor);
  yy_destructor(yypParser,177,&yymsp[-2].minor);
}
        break;
      case 299: /* exprx ::= expr COLLATE ID_COLLATE */
      case 300: /* exprx ::= RAISE LP raisetype COMMA ID_ERR_MSG RP */ yytestcase(yyruleno==300);
{  yy_destructor(yypParser,199,&yymsp[-2].minor);
}
        break;
      case 302: /* expr ::= */
{
                                                yygotominor.yy490 = new SqliteExpr();
                                                objectForTokens = yygotominor.yy490;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 305: /* likeop ::= LIKE_KW|MATCH */
{yygotominor.yy374 = new SqliteExpr::LikeOp(SqliteExpr::likeOp(yymsp[0].minor.yy0->value));}
        break;
      case 306: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
{
                                                yymsp[-4].minor.yy13->append(yymsp[-2].minor.yy490);
                                                yymsp[-4].minor.yy13->append(yymsp[0].minor.yy490);
                                                yygotominor.yy13 = yymsp[-4].minor.yy13;
                                            }
        break;
      case 307: /* case_exprlist ::= WHEN expr THEN expr */
{
                                                yygotominor.yy13 = new ParserExprList();
                                                yygotominor.yy13->append(yymsp[-2].minor.yy490);
                                                yygotominor.yy13->append(yymsp[0].minor.yy490);
                                            }
        break;
      case 314: /* nexprlist ::= nexprlist COMMA expr */
{
                                                yymsp[-2].minor.yy13->append(yymsp[0].minor.yy490);
                                                yygotominor.yy13 = yymsp[-2].minor.yy13;
                                                DONT_INHERIT_TOKENS("nexprlist");
                                            }
        break;
      case 315: /* nexprlist ::= exprx */
{
                                                yygotominor.yy13 = new ParserExprList();
                                                yygotominor.yy13->append(yymsp[0].minor.yy490);
                                            }
        break;
      case 316: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP where_opt */
{
                                                yygotominor.yy399 = new SqliteCreateIndex(
                                                        *(yymsp[-10].minor.yy237),
                                                        *(yymsp[-8].minor.yy237),
                                                        *(yymsp[-7].minor.yy211),
                                                        *(yymsp[-6].minor.yy211),
                                                        *(yymsp[-4].minor.yy211),
                                                        *(yymsp[-2].minor.yy139),
                                                        yymsp[0].minor.yy490
                                                    );
                                                delete yymsp[-8].minor.yy237;
                                                delete yymsp[-10].minor.yy237;
                                                delete yymsp[-7].minor.yy211;
                                                delete yymsp[-6].minor.yy211;
                                                delete yymsp[-4].minor.yy211;
                                                delete yymsp[-2].minor.yy139;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 317: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON ID_TAB */
{  yy_destructor(yypParser,177,&yymsp[-3].minor);
}
        break;
      case 322: /* idxlist_opt ::= */
{yygotominor.yy139 = new ParserIndexedColumnList();}
        break;
      case 323: /* idxlist_opt ::= LP idxlist RP */
{yygotominor.yy139 = yymsp[-1].minor.yy139;}
        break;
      case 324: /* idxlist ::= idxlist COMMA idxlist_single */
{
                                                yymsp[-2].minor.yy139->append(yymsp[0].minor.yy90);
                                                yygotominor.yy139 = yymsp[-2].minor.yy139;
                                                DONT_INHERIT_TOKENS("idxlist");
                                            }
        break;
      case 325: /* idxlist ::= idxlist_single */
{
                                                yygotominor.yy139 = new ParserIndexedColumnList();
                                                yygotominor.yy139->append(yymsp[0].minor.yy90);
                                            }
        break;
      case 326: /* idxlist_single ::= nm collate sortorder */
      case 327: /* idxlist_single ::= ID_COL */ yytestcase(yyruleno==327);
{
                                                SqliteIndexedColumn* obj =
                                                    new SqliteIndexedColumn(
                                                        *(yymsp[-2].minor.yy211),
                                                        *(yymsp[-1].minor.yy211),
                                                        *(yymsp[0].minor.yy226)
                                                    );
                                                yygotominor.yy90 = obj;
                                                delete yymsp[0].minor.yy226;
                                                delete yymsp[-2].minor.yy211;
                                                delete yymsp[-1].minor.yy211;
                                                objectForTokens = yygotominor.yy90;
                                            }
        break;
      case 331: /* cmd ::= DROP INDEX ifexists fullname */
{
                                                yygotominor.yy399 = new SqliteDropIndex(*(yymsp[-1].minor.yy237), yymsp[0].minor.yy66->name1, yymsp[0].minor.yy66->name2);
                                                delete yymsp[-1].minor.yy237;
                                                delete yymsp[0].minor.yy66;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 334: /* cmd ::= VACUUM */
{
                                                yygotominor.yy399 = new SqliteVacuum();
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 335: /* cmd ::= VACUUM nm */
{
                                                yygotominor.yy399 = new SqliteVacuum(*(yymsp[0].minor.yy211));
                                                delete yymsp[0].minor.yy211;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 336: /* cmd ::= PRAGMA nm dbnm */
{
                                                yygotominor.yy399 = new SqlitePragma(*(yymsp[-1].minor.yy211), *(yymsp[0].minor.yy211));
                                                delete yymsp[-1].minor.yy211;
                                                delete yymsp[0].minor.yy211;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 337: /* cmd ::= PRAGMA nm dbnm EQ nmnum */
      case 339: /* cmd ::= PRAGMA nm dbnm EQ minus_num */ yytestcase(yyruleno==339);
{
                                                yygotominor.yy399 = new SqlitePragma(*(yymsp[-3].minor.yy211), *(yymsp[-2].minor.yy211), *(yymsp[0].minor.yy21), true);
                                                delete yymsp[-3].minor.yy211;
                                                delete yymsp[-2].minor.yy211;
                                                delete yymsp[0].minor.yy21;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 338: /* cmd ::= PRAGMA nm dbnm LP nmnum RP */
      case 340: /* cmd ::= PRAGMA nm dbnm LP minus_num RP */ yytestcase(yyruleno==340);
{
                                                yygotominor.yy399 = new SqlitePragma(*(yymsp[-4].minor.yy211), *(yymsp[-3].minor.yy211), *(yymsp[-1].minor.yy21), false);
                                                delete yymsp[-4].minor.yy211;
                                                delete yymsp[-3].minor.yy211;
                                                delete yymsp[-1].minor.yy21;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 344: /* nmnum ::= nm */
{
                                                yygotominor.yy21 = new QVariant(*(yymsp[0].minor.yy211));
                                                delete yymsp[0].minor.yy211;
                                            }
        break;
      case 350: /* minus_num ::= MINUS number */
{
                                                if (yymsp[0].minor.yy21->type() == QVariant::Double)
                                                    *(yymsp[0].minor.yy21) = -(yymsp[0].minor.yy21->toDouble());
                                                else if (yymsp[0].minor.yy21->type() == QVariant::LongLong)
                                                {
                                                    if (parserContext->isCandidateForMaxNegativeNumber())
                                                        *(yymsp[0].minor.yy21) = std::numeric_limits<qint64>::min();
                                                    else
                                                        *(yymsp[0].minor.yy21) = -(yymsp[0].minor.yy21->toLongLong());
                                                }
                                                else
                                                    Q_ASSERT_X(true, "producing minus number", "QVariant is neither of Double or LongLong.");

                                                yygotominor.yy21 = yymsp[0].minor.yy21;
                                            }
        break;
      case 353: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list END */
{
                                                yygotominor.yy399 = new SqliteCreateTrigger(
                                                        *(yymsp[-13].minor.yy376),
                                                        *(yymsp[-11].minor.yy237),
                                                        *(yymsp[-10].minor.yy211),
                                                        *(yymsp[-9].minor.yy211),
                                                        *(yymsp[-5].minor.yy211),
                                                        *(yymsp[-8].minor.yy152),
                                                        yymsp[-7].minor.yy309,
                                                        *(yymsp[-4].minor.yy409),
                                                        yymsp[-3].minor.yy490,
                                                        *(yymsp[-1].minor.yy214),
                                                        3
                                                    );
                                                delete yymsp[-11].minor.yy237;
                                                delete yymsp[-13].minor.yy376;
                                                delete yymsp[-8].minor.yy152;
                                                delete yymsp[-4].minor.yy409;
                                                delete yymsp[-10].minor.yy211;
                                                delete yymsp[-5].minor.yy211;
                                                delete yymsp[-9].minor.yy211;
                                                delete yymsp[-1].minor.yy214;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 354: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause */
{
                                                QList<SqliteQuery *> CL;

                                                yygotominor.yy399 = new SqliteCreateTrigger(
                                                        *(yymsp[-10].minor.yy376),
                                                        *(yymsp[-8].minor.yy237),
                                                        *(yymsp[-7].minor.yy211),
                                                        *(yymsp[-6].minor.yy211),
                                                        *(yymsp[-2].minor.yy211),
                                                        *(yymsp[-5].minor.yy152),
                                                        yymsp[-4].minor.yy309,
                                                        *(yymsp[-1].minor.yy409),
                                                        yymsp[0].minor.yy490,
                                                        CL,
                                                        3
                                                    );
                                                delete yymsp[-8].minor.yy237;
                                                delete yymsp[-10].minor.yy376;
                                                delete yymsp[-5].minor.yy152;
                                                delete yymsp[-1].minor.yy409;
                                                delete yymsp[-7].minor.yy211;
                                                delete yymsp[-2].minor.yy211;
                                                delete yymsp[-6].minor.yy211;
                                                objectForTokens = yygotominor.yy399;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 355: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list */
{
                                                yygotominor.yy399 = new SqliteCreateTrigger(
                                                *(yymsp[-12].minor.yy376),
                                                *(yymsp[-10].minor.yy237),
                                                *(yymsp[-9].minor.yy211),
                                                *(yymsp[-8].minor.yy211),
                                                *(yymsp[-4].minor.yy211),
                                                *(yymsp[-7].minor.yy152),
                                                yymsp[-6].minor.yy309,
                                                *(yymsp[-3].minor.yy409),
                                                yymsp[-2].minor.yy490,
                                                *(yymsp[0].minor.yy214),
                                                3
                                                );
                                                delete yymsp[-10].minor.yy237;
                                                delete yymsp[-12].minor.yy376;
                                                delete yymsp[-7].minor.yy152;
                                                delete yymsp[-3].minor.yy409;
                                                delete yymsp[-9].minor.yy211;
                                                delete yymsp[-4].minor.yy211;
                                                delete yymsp[-8].minor.yy211;
                                                delete yymsp[0].minor.yy214;
                                                objectForTokens = yygotominor.yy399;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 356: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON ID_TAB */
{  yy_destructor(yypParser,179,&yymsp[-8].minor);
  yy_destructor(yypParser,177,&yymsp[-5].minor);
  yy_destructor(yypParser,262,&yymsp[-3].minor);
  yy_destructor(yypParser,263,&yymsp[-2].minor);
}
        break;
      case 359: /* trigger_time ::= BEFORE */
{yygotominor.yy152 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::BEFORE);}
        break;
      case 360: /* trigger_time ::= AFTER */
{yygotominor.yy152 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::AFTER);}
        break;
      case 361: /* trigger_time ::= INSTEAD OF */
{yygotominor.yy152 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::INSTEAD_OF);}
        break;
      case 362: /* trigger_time ::= */
{yygotominor.yy152 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::null);}
        break;
      case 363: /* trigger_event ::= DELETE */
{
                                                yygotominor.yy309 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::DELETE);
                                                objectForTokens = yygotominor.yy309;
                                            }
        break;
      case 364: /* trigger_event ::= INSERT */
{
                                                yygotominor.yy309 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::INSERT);
                                                objectForTokens = yygotominor.yy309;
                                            }
        break;
      case 365: /* trigger_event ::= UPDATE */
{
                                                yygotominor.yy309 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::UPDATE);
                                                objectForTokens = yygotominor.yy309;
                                            }
        break;
      case 366: /* trigger_event ::= UPDATE OF inscollist */
{
                                                yygotominor.yy309 = new SqliteCreateTrigger::Event(*(yymsp[0].minor.yy445));
                                                delete yymsp[0].minor.yy445;
                                                objectForTokens = yygotominor.yy309;
                                            }
        break;
      case 367: /* foreach_clause ::= */
{yygotominor.yy409 = new SqliteCreateTrigger::Scope(SqliteCreateTrigger::Scope::null);}
        break;
      case 368: /* foreach_clause ::= FOR EACH ROW */
{yygotominor.yy409 = new SqliteCreateTrigger::Scope(SqliteCreateTrigger::Scope::FOR_EACH_ROW);}
        break;
      case 371: /* trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI */
{
                                                yymsp[-2].minor.yy214->append(yymsp[-1].minor.yy399);
                                                yygotominor.yy214 = yymsp[-2].minor.yy214;
                                                DONT_INHERIT_TOKENS("trigger_cmd_list");
                                            }
        break;
      case 372: /* trigger_cmd_list ::= trigger_cmd SEMI */
{
                                                yygotominor.yy214 = new ParserQueryList();
                                                yygotominor.yy214->append(yymsp[-1].minor.yy399);
                                            }
        break;
      case 373: /* trigger_cmd_list ::= SEMI */
{
                                                yygotominor.yy214 = new ParserQueryList();
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 378: /* raisetype ::= ROLLBACK|ABORT|FAIL */
{yygotominor.yy0 = yymsp[0].minor.yy0;}
        break;
      case 379: /* cmd ::= DROP TRIGGER ifexists fullname */
{
                                                yygotominor.yy399 = new SqliteDropTrigger(*(yymsp[-1].minor.yy237), yymsp[0].minor.yy66->name1, yymsp[0].minor.yy66->name2);
                                                delete yymsp[-1].minor.yy237;
                                                delete yymsp[0].minor.yy66;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 382: /* cmd ::= ATTACH database_kw_opt expr AS expr key_opt */
{
                                                yygotominor.yy399 = new SqliteAttach(*(yymsp[-4].minor.yy237), yymsp[-3].minor.yy490, yymsp[-1].minor.yy490, yymsp[0].minor.yy490);
                                                delete yymsp[-4].minor.yy237;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 383: /* cmd ::= DETACH database_kw_opt expr */
{
                                                yygotominor.yy399 = new SqliteDetach(*(yymsp[-1].minor.yy237), yymsp[0].minor.yy490);
                                                delete yymsp[-1].minor.yy237;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 388: /* cmd ::= REINDEX */
{yygotominor.yy399 = new SqliteReindex();}
        break;
      case 389: /* cmd ::= REINDEX nm dbnm */
      case 390: /* cmd ::= REINDEX ID_COLLATE */ yytestcase(yyruleno==390);
{
                                                yygotominor.yy399 = new SqliteReindex(*(yymsp[-1].minor.yy211), *(yymsp[0].minor.yy211));
                                                delete yymsp[-1].minor.yy211;
                                                delete yymsp[0].minor.yy211;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 393: /* cmd ::= ANALYZE */
{
                                                yygotominor.yy399 = new SqliteAnalyze();
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 394: /* cmd ::= ANALYZE nm dbnm */
{
                                                yygotominor.yy399 = new SqliteAnalyze(*(yymsp[-1].minor.yy211), *(yymsp[0].minor.yy211));
                                                delete yymsp[-1].minor.yy211;
                                                delete yymsp[0].minor.yy211;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 397: /* cmd ::= ALTER TABLE fullname RENAME TO nm */
{
                                                yygotominor.yy399 = new SqliteAlterTable(
                                                        yymsp[-3].minor.yy66->name1,
                                                        yymsp[-3].minor.yy66->name2,
                                                        *(yymsp[0].minor.yy211)
                                                    );
                                                delete yymsp[0].minor.yy211;
                                                delete yymsp[-3].minor.yy66;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 398: /* cmd ::= ALTER TABLE fullname ADD kwcolumn_opt column */
{
                                                yygotominor.yy399 = new SqliteAlterTable(
                                                        yymsp[-3].minor.yy66->name1,
                                                        yymsp[-3].minor.yy66->name2,
                                                        *(yymsp[-1].minor.yy237),
                                                        yymsp[0].minor.yy425
                                                    );
                                                delete yymsp[-1].minor.yy237;
                                                delete yymsp[-3].minor.yy66;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 399: /* cmd ::= ALTER TABLE fullname RENAME TO ID_TAB_NEW */
{  yy_destructor(yypParser,181,&yymsp[-3].minor);
}
        break;
      case 405: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm */
{
                                                yygotominor.yy399 = new SqliteCreateVirtualTable(
                                                        *(yymsp[-4].minor.yy237),
                                                        *(yymsp[-3].minor.yy211),
                                                        *(yymsp[-2].minor.yy211),
                                                        *(yymsp[0].minor.yy211)
                                                    );
                                                delete yymsp[-4].minor.yy237;
                                                delete yymsp[-3].minor.yy211;
                                                delete yymsp[-2].minor.yy211;
                                                delete yymsp[0].minor.yy211;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 406: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm LP vtabarglist RP */
{
                                                yygotominor.yy399 = new SqliteCreateVirtualTable(
                                                        *(yymsp[-7].minor.yy237),
                                                        *(yymsp[-6].minor.yy211),
                                                        *(yymsp[-5].minor.yy211),
                                                        *(yymsp[-3].minor.yy211),
                                                        *(yymsp[-1].minor.yy445)
                                                    );
                                                delete yymsp[-6].minor.yy211;
                                                delete yymsp[-5].minor.yy211;
                                                delete yymsp[-3].minor.yy211;
                                                delete yymsp[-7].minor.yy237;
                                                delete yymsp[-1].minor.yy445;
                                                objectForTokens = yygotominor.yy399;
                                            }
        break;
      case 409: /* vtabarglist ::= vtabarg */
{
                                                yygotominor.yy445 = new ParserStringList();
                                                yygotominor.yy445->append((yymsp[0].minor.yy211)->mid(1)); // mid(1) to skip the first whitespace added in vtabarg
                                                delete yymsp[0].minor.yy211;
                                            }
        break;
      case 410: /* vtabarglist ::= vtabarglist COMMA vtabarg */
{
                                                yymsp[-2].minor.yy445->append((yymsp[0].minor.yy211)->mid(1)); // mid(1) to skip the first whitespace added in vtabarg
                                                yygotominor.yy445 = yymsp[-2].minor.yy445;
                                                delete yymsp[0].minor.yy211;
                                                DONT_INHERIT_TOKENS("vtabarglist");
                                            }
        break;
      case 412: /* vtabarg ::= vtabarg vtabargtoken */
{
                                                yymsp[-1].minor.yy211->append(" "+ *(yymsp[0].minor.yy211));
                                                yygotominor.yy211 = yymsp[-1].minor.yy211;
                                                delete yymsp[0].minor.yy211;
                                            }
        break;
      case 413: /* vtabargtoken ::= ANY */
{
                                                yygotominor.yy211 = new QString(yymsp[0].minor.yy0->value);
                                            }
        break;
      case 414: /* vtabargtoken ::= LP anylist RP */
{
                                                yygotominor.yy211 = new QString("(");
                                                yygotominor.yy211->append(*(yymsp[-1].minor.yy211));
                                                yygotominor.yy211->append(")");
                                                delete yymsp[-1].minor.yy211;
                                            }
        break;
      case 416: /* anylist ::= anylist LP anylist RP */
{
                                                yygotominor.yy211 = yymsp[-3].minor.yy211;
                                                yygotominor.yy211->append("(");
                                                yygotominor.yy211->append(*(yymsp[-1].minor.yy211));
                                                yygotominor.yy211->append(")");
                                                delete yymsp[-1].minor.yy211;
                                                DONT_INHERIT_TOKENS("anylist");
                                            }
        break;
      case 417: /* anylist ::= anylist ANY */
{
                                                yygotominor.yy211 = yymsp[-1].minor.yy211;
                                                yygotominor.yy211->append(yymsp[0].minor.yy0->value);
                                                DONT_INHERIT_TOKENS("anylist");
                                            }
        break;
      case 418: /* with ::= */
{yygotominor.yy367 = nullptr;}
        break;
      case 419: /* with ::= WITH wqlist */
{
                                                yygotominor.yy367 = yymsp[0].minor.yy367;
                                                objectForTokens = yygotominor.yy367;
                                            }
        break;
      case 420: /* with ::= WITH RECURSIVE wqlist */
{
                                                yygotominor.yy367 = yymsp[0].minor.yy367;
                                                yygotominor.yy367->recursive = true;
                                                objectForTokens = yygotominor.yy367;
                                            }
        break;
      case 421: /* wqlist ::= nm idxlist_opt AS LP select RP */
{
                                                yygotominor.yy367 = SqliteWith::append(*(yymsp[-5].minor.yy211), *(yymsp[-4].minor.yy139), yymsp[-1].minor.yy123);
                                                delete yymsp[-5].minor.yy211;
                                                delete yymsp[-4].minor.yy139;
                                            }
        break;
      case 422: /* wqlist ::= wqlist COMMA nm idxlist_opt AS LP select RP */
{
                                                yygotominor.yy367 = SqliteWith::append(yymsp[-7].minor.yy367, *(yymsp[-5].minor.yy211), *(yymsp[-4].minor.yy139), yymsp[-1].minor.yy123);
                                                delete yymsp[-5].minor.yy211;
                                                delete yymsp[-4].minor.yy139;
                                                DONT_INHERIT_TOKENS("wqlist");
                                            }
        break;
      case 423: /* wqlist ::= ID_TAB_NEW */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy367 = new SqliteWith();
                                            }
        break;
      default:
      /* (0) input ::= cmdlist */ yytestcase(yyruleno==0);
        break;
      };
  }
  assert( yyruleno>=0 && yyruleno<(int)(sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0])) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;

  // Store tokens for the rule in parser context
  QList<Token*> allTokens;
  QList<Token*> allTokensWithAllInherited;
  QString keyForTokensMap;
  int tokensMapKeyCnt;
  if (parserContext->setupTokens)
  {
      if (objectForTokens)
      {
          // In case this is a list with recurrent references we need
          // to clear tokens before adding the new and extended list.
          objectForTokens->tokens.clear();
      }

      QList<Token*> tokens;
      for (int i = yypParser->yyidx - yysize + 1; i <= yypParser->yyidx; i++)
      {
          tokens.clear();
          const char* fieldName = yyTokenName[yypParser->yystack[i].major];
          if (parserContext->isManagedToken(yypParser->yystack[i].minor.yy0))
              tokens += yypParser->yystack[i].minor.yy0;

          tokens += *(yypParser->yystack[i].tokens);

          if (!noTokenInheritanceFields.contains(fieldName))
          {
              if (objectForTokens)
              {
                  keyForTokensMap = fieldName;
                  tokensMapKeyCnt = 2;
                  while (objectForTokens->tokensMap.contains(keyForTokensMap))
                      keyForTokensMap = fieldName + QString::number(tokensMapKeyCnt++);

                  objectForTokens->tokensMap[keyForTokensMap] = parserContext->getTokenPtrList(tokens);
              }

              allTokens += tokens;
          }
          else
          {
              // If field is mentioned only once, then only one occurance of it will be ignored.
              // Second one should be inherited. See "anylist" definition for explanation why.
              noTokenInheritanceFields.removeOne(fieldName);
          }
          allTokensWithAllInherited += tokens;
      }
      if (objectForTokens)
      {
          objectForTokens->tokens += parserContext->getTokenPtrList(allTokens);
      }
  }

  // Clear token lists
  for (int i = yypParser->yyidx - yysize + 1; i <= yypParser->yyidx; i++)
  {
      delete yypParser->yystack[i].tokens;
      yypParser->yystack[i].tokens = nullptr;
  }

  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = (YYACTIONTYPE)yyact;
      yymsp->major = (YYCODETYPE)yygoto;
      yymsp->minor = yygotominor;
      if (parserContext->setupTokens)
          *(yypParser->yystack[yypParser->yyidx].tokens) = allTokens;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
      if (parserContext->setupTokens)
      {
          QList<Token*>* tokensPtr = yypParser->yystack[yypParser->yyidx].tokens;
          *tokensPtr = allTokensWithAllInherited + *tokensPtr;
      }
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3_parseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3_parseARG_FETCH;
#define TOKEN (yyminor.yy0)

    UNUSED_PARAMETER(yymajor);
    parserContext->error(TOKEN, QObject::tr("Syntax error"));
    //qDebug() << "near " << TOKEN->toString() << ": syntax error";
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3_parseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3_parseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3_parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3_parseTOKENTYPE yyminor       /* The value for the token */
  sqlite3_parseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
    yypParser->yystack[0].tokens = new QList<Token*>();
  }
  yyminorunion.yy0 = yyminor;
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif
  sqlite3_parseARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s [%s] (lemon type: %s)\n",
            yyTracePrompt,
            yyminor->value.toLatin1().data(),
            yyminor->typeString().toLatin1().data(),
            yyTokenName[yymajor]);  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 1; // not 3 valid tokens, but 1
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor,yyminorunion);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      yymajor = YYNOCODE;

#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 1; // not 3 valid tokens, but 1
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
