#! /usr/bin/env bash
# I may later put the 'Build' and 'Clean' scripts in here as functions
# until I can work out a proper makefile system

#Help function
helpme()
{
	echo "SharpDot install"
	echo "Usage: ./install.sh [system|user]"
	echo "System installs the cursor theme to the system for all users."
	echo "User installs the cursor theme for the current user only."	
}

# System install
system_install()
{
	echo "Copying SharpDot to system icon folder..."
	cp -r $CURSDIR $SYSTDIR
	if ! [ -e $SYSTDIR/default ]
		then
		mkdir $SYSTDIR/default
	fi
	cat >  $SYSTDIR/default/index.theme << EOF
[Icon Theme]
Inherits=SharpDot
EOF
	
# Uncomment if you would like to use Debian's 'alternatives' system
# to select cursors.  Will only work when installing to the system.
#	if ! [ -e /usr/bin/update-alternatives ]
#	then
#		echo "Please install 'update-alternatives'"
#		echo "to register cursors to your system."
#		exit 1
#	else 
#		echo "Registering SharpDot with alternatives system..."
#	cp $CURSDIR/index.theme /etc/X11/cursors/SharpDot.theme
#	update-alternatives --install /usr/share/icons/default/index.theme x-cursor-theme /etc/X11/cursors/sharpdot.theme 50
#	fi
}

# User install
user_install()
{
	echo "Copying SharpDot to local icon folder..."
	cp -r $CURSDIR $USERDIR
	cat >  $USERDIR/default/index.theme << EOF
[Icon Theme]
Inherits=SharpDot
EOF
}

# Main Body
CURSDIR=$(pwd)/SharpDot
USERDIR=$HOME/.icons
SYSTDIR=/usr/share/icons

OPT=$1
if ! [ $OPT ]
	then 
		helpme
		exit 0
fi

# Options?
if ! [ $OPT = "user" -o $OPT = "system" ]
	then
		echo "Please specify 'user' or 'system'."
		exit 1
	else echo "Installing to $OPT..."
		export INSTALL=$OPT"_install"
		$INSTALL
		echo "Successfully installed"
		echo "You may now select the theme with your system's cursor theme chooser"
fi
exit 0
