/*
   SPDX-FileCopyrightText: 2020-2023 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/

#pragma once

#include <QWidget>

#include "libruqolawidgets_private_export.h"
class QLineEdit;
class MessageListView;
class QLabel;
class ListMessagesModelFilterProxyModel;
class RocketChatAccount;
class Room;

namespace TextEditTextToSpeech
{
class TextToSpeechContainerWidget;
}

class LIBRUQOLAWIDGETS_TESTS_EXPORT ShowListMessageBaseWidget : public QWidget
{
    Q_OBJECT
public:
    explicit ShowListMessageBaseWidget(RocketChatAccount *account, QWidget *parent = nullptr);
    ~ShowListMessageBaseWidget() override;

    void setModel(ListMessagesModelFilterProxyModel *model);
    [[nodiscard]] MessageListView *messageListView() const;

    void setRoom(Room *room);

Q_SIGNALS:
    void loadMoreElements();

private:
    void updateLabel();
    void slotSearchMessageTextChanged(const QString &str);

    [[nodiscard]] QString displayShowMessageInRoom() const;
    QLineEdit *const mSearchMessageLineEdit;
    QLabel *const mMessageListInfo;
    MessageListView *const mMessageListView;
    ListMessagesModelFilterProxyModel *mModel = nullptr;
    TextEditTextToSpeech::TextToSpeechContainerWidget *const mTextToSpeechWidget = nullptr;
};
